/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.libs.ricecode.similarity.LevenshteinDistanceStrategy;
import fr.xephi.authme.libs.ricecode.similarity.StringSimilarityServiceImpl;
import java.io.File;
import java.util.Arrays;

public final class StringUtils {
    private StringUtils() {
    }

    public static double getDifference(String first, String second) {
        if (first == null || second == null) {
            return 1.0;
        }
        StringSimilarityServiceImpl service = new StringSimilarityServiceImpl(new LevenshteinDistanceStrategy());
        return Math.abs(service.score(first, second) - 1.0);
    }

    public static boolean containsAny(String str, String ... pieces) {
        if (str == null) {
            return false;
        }
        for (String piece : pieces) {
            if (piece == null || !str.contains(piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String join(String delimiter, Iterable<String> elements) {
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (StringUtils.isEmpty(element)) continue;
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(element);
        }
        return sb.toString();
    }

    public static String join(String delimiter, String ... elements) {
        return StringUtils.join(delimiter, Arrays.asList(elements));
    }

    public static String formatException(Throwable th) {
        return "[" + th.getClass().getSimpleName() + "]: " + th.getMessage();
    }

    public static String makePath(String ... elements) {
        return StringUtils.join(File.separator, elements);
    }
}

