/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public final class FileUtils {
    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileFromResource(File destinationFile, String resourcePath) {
        if (destinationFile.exists()) {
            return true;
        }
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            ConsoleLogger.warning("Cannot create parent directories for '" + destinationFile + "'");
            return false;
        }
        String normalizedPath = resourcePath.replace("\\", "/");
        try (InputStream is = AuthMe.class.getClassLoader().getResourceAsStream(normalizedPath);){
            if (is == null) {
                ConsoleLogger.warning(String.format("Cannot copy resource '%s' to file '%s': cannot load resource", resourcePath, destinationFile.getPath()));
                return false;
            }
            Files.copy(is, destinationFile.toPath(), new CopyOption[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ConsoleLogger.logException(String.format("Cannot copy resource '%s' to file '%s':", resourcePath, destinationFile.getPath()), e);
        }
        return false;
    }

    public static void purgeDirectory(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File target : files) {
            if (target.isDirectory()) {
                FileUtils.purgeDirectory(target);
            }
            FileUtils.delete(target);
        }
    }

    public static void delete(File file) {
        boolean result;
        if (file != null && !(result = file.delete())) {
            ConsoleLogger.warning("Could not delete file '" + file + "'");
        }
    }
}

