/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> getRange(List<T> list, int start, int count) {
        if (start >= list.size() || count <= 0) {
            return new ArrayList();
        }
        if (start < 0) {
            start = 0;
        }
        int end = Math.min(list.size(), start + count);
        return list.subList(start, end);
    }

    public static <T> List<T> getRange(List<T> list, int start) {
        if (start >= list.size()) {
            return new ArrayList();
        }
        return CollectionUtils.getRange(list, start, list.size() - start);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static <T> List<T> filterCommonStart(List<T> list1, List<T> list2) {
        ArrayList<T> commonStart = new ArrayList<T>();
        int minSize = Math.min(list1.size(), list2.size());
        for (int i = 0; i < minSize && Objects.equals(list1.get(i), list2.get(i)); ++i) {
            commonStart.add(list1.get(i));
        }
        return commonStart;
    }
}

