/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.util;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BukkitService
implements SettingsDependent {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TICKS_PER_MINUTE = 1200;
    private final AuthMe authMe;
    private final boolean getOnlinePlayersIsCollection;
    private Method getOnlinePlayers;
    private boolean useAsyncTasks;

    public BukkitService(AuthMe authMe, Settings settings) {
        this.authMe = authMe;
        this.getOnlinePlayersIsCollection = BukkitService.initializeOnlinePlayersIsCollectionField();
        this.reload(settings);
    }

    public int scheduleSyncDelayedTask(Runnable task) {
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.authMe, task);
    }

    public int scheduleSyncDelayedTask(Runnable task, long delay) {
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.authMe, task, delay);
    }

    public void scheduleSyncTaskFromOptionallyAsyncTask(Runnable task) {
        if (this.useAsyncTasks) {
            this.scheduleSyncDelayedTask(task);
        } else {
            task.run();
        }
    }

    public BukkitTask runTask(Runnable task) {
        return Bukkit.getScheduler().runTask((Plugin)this.authMe, task);
    }

    public BukkitTask runTaskLater(Runnable task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.authMe, task, delay);
    }

    public void runTaskOptionallyAsync(Runnable task) {
        if (this.useAsyncTasks) {
            this.runTaskAsynchronously(task);
        } else {
            task.run();
        }
    }

    public BukkitTask runTaskAsynchronously(Runnable task) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.authMe, task);
    }

    public BukkitTask runTaskTimerAsynchronously(Runnable task, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.authMe, task, delay, period);
    }

    public BukkitTask runTaskTimer(BukkitRunnable task, long delay, long period) {
        return task.runTaskTimer((Plugin)this.authMe, period, delay);
    }

    public int broadcastMessage(String message) {
        return Bukkit.broadcastMessage((String)message);
    }

    public Player getPlayerExact(String name) {
        return this.authMe.getServer().getPlayerExact(name);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        return Bukkit.getBannedPlayers();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        return Bukkit.getOfflinePlayers();
    }

    public Collection<? extends Player> getOnlinePlayers() {
        if (this.getOnlinePlayersIsCollection) {
            return Bukkit.getOnlinePlayers();
        }
        try {
            Object obj;
            if (this.getOnlinePlayers == null) {
                this.getOnlinePlayers = Bukkit.class.getDeclaredMethod("getOnlinePlayers", new Class[0]);
            }
            if ((obj = this.getOnlinePlayers.invoke(null, new Object[0])) instanceof Collection) {
                return (Collection)obj;
            }
            if (obj instanceof Player[]) {
                return Arrays.asList((Player[])obj);
            }
            String type = obj == null ? "null" : obj.getClass().getName();
            ConsoleLogger.warning("Unknown list of online players of type " + type);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ConsoleLogger.logException("Could not retrieve list of online players:", e);
        }
        return Collections.emptyList();
    }

    public void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    public World getWorld(String name) {
        return Bukkit.getWorld((String)name);
    }

    @Override
    public void reload(Settings settings) {
        this.useAsyncTasks = settings.getProperty(PluginSettings.USE_ASYNC_TASKS);
    }

    private static boolean initializeOnlinePlayersIsCollectionField() {
        try {
            Method method = Bukkit.class.getDeclaredMethod("getOnlinePlayers", new Class[0]);
            return method.getReturnType() == Collection.class;
        }
        catch (NoSuchMethodException e) {
            ConsoleLogger.warning("Error verifying if getOnlinePlayers is a collection! Method doesn't exist");
            return false;
        }
    }

    public BanEntry banIp(String ip, String reason, Date expires, String source) {
        return Bukkit.getServer().getBanList(BanList.Type.IP).addBan(ip, reason, expires, source);
    }
}

