/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task.purge;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.task.purge.PurgeService;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

class PurgeTask
extends BukkitRunnable {
    private static final int INTERVAL_CHECK = 5;
    private final PurgeService purgeService;
    private final PermissionsManager permissionsManager;
    private final UUID sender;
    private final Set<String> toPurge;
    private final OfflinePlayer[] offlinePlayers;
    private final int totalPurgeCount;
    private int currentPage = 0;

    PurgeTask(PurgeService service, PermissionsManager permissionsManager, CommandSender sender, Set<String> toPurge, OfflinePlayer[] offlinePlayers) {
        this.purgeService = service;
        this.permissionsManager = permissionsManager;
        this.sender = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        this.toPurge = toPurge;
        this.totalPurgeCount = toPurge.size();
        this.offlinePlayers = offlinePlayers;
    }

    public void run() {
        int nextPosition;
        if (this.toPurge.isEmpty()) {
            this.finish();
            return;
        }
        HashSet<OfflinePlayer> playerPortion = new HashSet<OfflinePlayer>(5);
        HashSet<String> namePortion = new HashSet<String>(5);
        for (int i = 0; i < 5 && this.offlinePlayers.length > (nextPosition = this.currentPage * 5 + i); ++i) {
            OfflinePlayer offlinePlayer = this.offlinePlayers[nextPosition];
            if (!this.toPurge.remove(offlinePlayer.getName().toLowerCase()) || this.permissionsManager.hasPermissionOffline(offlinePlayer, (PermissionNode)PlayerStatePermission.BYPASS_PURGE)) continue;
            playerPortion.add(offlinePlayer);
            namePortion.add(offlinePlayer.getName());
        }
        if (!this.toPurge.isEmpty() && playerPortion.isEmpty()) {
            ConsoleLogger.info("Finished lookup up offlinePlayers. Begin looking purging player names only");
            for (String name : this.toPurge) {
                if (this.permissionsManager.hasPermissionOffline(name, (PermissionNode)PlayerStatePermission.BYPASS_PURGE)) continue;
                namePortion.add(name);
            }
            this.toPurge.clear();
        }
        ++this.currentPage;
        this.purgeService.executePurge(playerPortion, namePortion);
        if (this.currentPage % 20 == 0) {
            int completed = this.totalPurgeCount - this.toPurge.size();
            this.sendMessage("[AuthMe] Purge progress " + completed + '/' + this.totalPurgeCount);
        }
    }

    private void finish() {
        this.cancel();
        this.sendMessage(ChatColor.GREEN + "[AuthMe] Database has been purged successfully");
        ConsoleLogger.info("Purge finished!");
        this.purgeService.setPurging(false);
    }

    private void sendMessage(String message) {
        if (this.sender == null) {
            Bukkit.getConsoleSender().sendMessage(message);
        } else {
            Player player = Bukkit.getPlayer((UUID)this.sender);
            if (player != null) {
                player.sendMessage(message);
            }
        }
    }
}

