/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task.purge;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PurgeSettings;
import fr.xephi.authme.task.purge.PurgeExecutor;
import fr.xephi.authme.task.purge.PurgeTask;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.CollectionUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class PurgeService {
    @Inject
    private BukkitService bukkitService;
    @Inject
    private DataSource dataSource;
    @Inject
    private Settings settings;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private PurgeExecutor purgeExecutor;
    private boolean isPurging = false;

    PurgeService() {
    }

    public void runAutoPurge() {
        int daysBeforePurge = this.settings.getProperty(PurgeSettings.DAYS_BEFORE_REMOVE_PLAYER);
        if (!this.settings.getProperty(PurgeSettings.USE_AUTO_PURGE).booleanValue()) {
            return;
        }
        if (daysBeforePurge <= 0) {
            ConsoleLogger.warning("Did not run auto purge: configured days before purging must be positive");
            return;
        }
        ConsoleLogger.info("Automatically purging the database...");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -daysBeforePurge);
        long until = calendar.getTimeInMillis();
        this.runPurge(null, until, false);
    }

    public void runPurge(CommandSender sender, long until, boolean includeEntriesWithLastLoginZero) {
        Set<String> toPurge = this.dataSource.getRecordsToPurge(until, includeEntriesWithLastLoginZero);
        if (CollectionUtils.isEmpty(toPurge)) {
            PurgeService.logAndSendMessage(sender, "No players to purge");
            return;
        }
        this.purgePlayers(sender, toPurge, this.bukkitService.getOfflinePlayers());
    }

    public void purgePlayers(CommandSender sender, Set<String> names, OfflinePlayer[] players) {
        if (this.isPurging) {
            PurgeService.logAndSendMessage(sender, "Purge is already in progress! Aborting purge request");
            return;
        }
        this.isPurging = true;
        PurgeTask purgeTask = new PurgeTask(this, this.permissionsManager, sender, names, players);
        this.bukkitService.runTaskTimer(purgeTask, 0L, 1L);
    }

    void setPurging(boolean purging) {
        this.isPurging = purging;
    }

    void executePurge(Collection<OfflinePlayer> players, Collection<String> names) {
        this.purgeExecutor.executePurge(players, names);
    }

    private static void logAndSendMessage(CommandSender sender, String message) {
        ConsoleLogger.info(message);
        if (sender != null && !(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage(message);
        }
    }
}

