/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task.purge;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PurgeSettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

class PurgeExecutor {
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private PluginHooks pluginHooks;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Server server;

    PurgeExecutor() {
    }

    public void executePurge(Collection<OfflinePlayer> players, Collection<String> names) {
        this.purgeFromAuthMe(names);
        this.purgeEssentials(players);
        this.purgeDat(players);
        this.purgeLimitedCreative(names);
        this.purgeAntiXray(names);
        this.purgePermissions(players);
    }

    synchronized void purgeAntiXray(Collection<String> cleared) {
        if (!this.settings.getProperty(PurgeSettings.REMOVE_ANTI_XRAY_FILE).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File("." + File.separator + "plugins" + File.separator + "AntiXRayData" + File.separator + "PlayerData");
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            return;
        }
        for (String file : dataFolder.list()) {
            File playerFile;
            if (!cleared.contains(file.toLowerCase()) || !(playerFile = new File(dataFolder, file)).exists() || !playerFile.delete()) continue;
            ++i;
        }
        ConsoleLogger.info("AutoPurge: Removed " + i + " AntiXRayData Files");
    }

    synchronized void purgeFromAuthMe(Collection<String> names) {
        this.dataSource.purgeRecords(names);
        ConsoleLogger.info(ChatColor.GOLD + "Deleted " + names.size() + " user accounts");
    }

    synchronized void purgeLimitedCreative(Collection<String> cleared) {
        if (!this.settings.getProperty(PurgeSettings.REMOVE_LIMITED_CREATIVE_INVENTORIES).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File("." + File.separator + "plugins" + File.separator + "LimitedCreative" + File.separator + "inventories");
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            return;
        }
        String[] stringArray = dataFolder.list();
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            File dataFile;
            String file;
            String name = file = stringArray[j];
            int idx = file.lastIndexOf("_creative.yml");
            if (idx != -1) {
                name = name.substring(0, idx);
            } else {
                idx = file.lastIndexOf("_adventure.yml");
                if (idx != -1) {
                    name = name.substring(0, idx);
                } else {
                    idx = file.lastIndexOf(".yml");
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                }
            }
            if (name.equals(file) || !cleared.contains(name.toLowerCase()) || !(dataFile = new File(dataFolder, file)).exists() || !dataFile.delete()) continue;
            ++i;
        }
        ConsoleLogger.info("AutoPurge: Removed " + i + " LimitedCreative Survival, Creative and Adventure files");
    }

    synchronized void purgeDat(Collection<OfflinePlayer> cleared) {
        if (!this.settings.getProperty(PurgeSettings.REMOVE_PLAYER_DAT).booleanValue()) {
            return;
        }
        int i = 0;
        File dataFolder = new File(this.server.getWorldContainer(), StringUtils.makePath(this.settings.getProperty(PurgeSettings.DEFAULT_WORLD), "players"));
        for (OfflinePlayer offlinePlayer : cleared) {
            File playerFile = new File(dataFolder, Utils.getUUIDorName(offlinePlayer) + ".dat");
            if (!playerFile.delete()) continue;
            ++i;
        }
        ConsoleLogger.info("AutoPurge: Removed " + i + " .dat Files");
    }

    synchronized void purgeEssentials(Collection<OfflinePlayer> cleared) {
        if (!this.settings.getProperty(PurgeSettings.REMOVE_ESSENTIALS_FILES).booleanValue()) {
            return;
        }
        int i = 0;
        File essentialsDataFolder = this.pluginHooks.getEssentialsDataFolder();
        if (essentialsDataFolder == null) {
            ConsoleLogger.info("Cannot purge Essentials: plugin is not loaded");
            return;
        }
        File userDataFolder = new File(essentialsDataFolder, "userdata");
        if (!userDataFolder.exists() || !userDataFolder.isDirectory()) {
            return;
        }
        for (OfflinePlayer offlinePlayer : cleared) {
            File playerFile = new File(userDataFolder, Utils.getUUIDorName(offlinePlayer) + ".yml");
            if (!playerFile.exists() || !playerFile.delete()) continue;
            ++i;
        }
        ConsoleLogger.info("AutoPurge: Removed " + i + " EssentialsFiles");
    }

    synchronized void purgePermissions(Collection<OfflinePlayer> cleared) {
        if (!this.settings.getProperty(PurgeSettings.REMOVE_PERMISSIONS).booleanValue()) {
            return;
        }
        for (OfflinePlayer offlinePlayer : cleared) {
            String name = offlinePlayer.getName();
            this.permissionsManager.removeAllGroups(this.bukkitService.getPlayerExact(name));
        }
        ConsoleLogger.info("AutoPurge: Removed permissions from " + cleared.size() + " player(s).");
    }
}

