/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.MessageTask;
import fr.xephi.authme.task.TimeoutTask;
import fr.xephi.authme.util.BukkitService;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class PlayerDataTaskManager {
    @Inject
    private Messages messages;
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private LimboCache limboCache;
    @Inject
    private PlayerCache playerCache;

    PlayerDataTaskManager() {
    }

    public void registerMessageTask(String name, boolean isRegistered) {
        int interval = this.settings.getProperty(RegistrationSettings.MESSAGE_INTERVAL);
        MessageKey key = this.getMessageKey(isRegistered);
        if (interval > 0) {
            PlayerData playerData = this.limboCache.getPlayerData(name);
            if (playerData == null) {
                ConsoleLogger.info("PlayerData for '" + name + "' is not available");
            } else {
                PlayerDataTaskManager.cancelTask(playerData.getMessageTask());
                BukkitTask messageTask = this.bukkitService.runTask(new MessageTask(name, this.messages.retrieve(key), interval, this.bukkitService, this.limboCache, this.playerCache));
                playerData.setMessageTask(messageTask);
            }
        }
    }

    public void registerTimeoutTask(Player player) {
        int timeout = this.settings.getProperty(RestrictionSettings.TIMEOUT) * 20;
        if (timeout > 0) {
            PlayerData playerData = this.limboCache.getPlayerData(player.getName());
            if (playerData == null) {
                ConsoleLogger.info("PlayerData for '" + player.getName() + "' is not available");
            } else {
                PlayerDataTaskManager.cancelTask(playerData.getTimeoutTask());
                String message = this.messages.retrieveSingle(MessageKey.LOGIN_TIMEOUT_ERROR, new String[0]);
                BukkitTask task = this.bukkitService.runTaskLater(new TimeoutTask(player, message, this.playerCache), timeout);
                playerData.setTimeoutTask(task);
            }
        }
    }

    private MessageKey getMessageKey(boolean isRegistered) {
        if (isRegistered) {
            return MessageKey.LOGIN_MESSAGE;
        }
        return this.settings.getProperty(RegistrationSettings.USE_EMAIL_REGISTRATION) != false ? MessageKey.REGISTER_EMAIL_MESSAGE : MessageKey.REGISTER_MESSAGE;
    }

    private static void cancelTask(BukkitTask task) {
        if (task != null) {
            task.cancel();
        }
    }
}

