/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.task;

import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.util.BukkitService;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class MessageTask
implements Runnable {
    private final String name;
    private final String[] message;
    private final int interval;
    private final BukkitService bukkitService;
    private final LimboCache limboCache;
    private final PlayerCache playerCache;

    public MessageTask(String name, String[] lines, int interval, BukkitService bukkitService, LimboCache limboCache, PlayerCache playerCache) {
        this.name = name;
        this.message = lines;
        this.interval = interval;
        this.bukkitService = bukkitService;
        this.limboCache = limboCache;
        this.playerCache = playerCache;
    }

    @Override
    public void run() {
        if (this.playerCache.isAuthenticated(this.name)) {
            return;
        }
        for (Player player : this.bukkitService.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(this.name)) continue;
            for (String ms : this.message) {
                player.sendMessage(ms);
            }
            BukkitTask nextTask = this.bukkitService.runTaskLater(this, this.interval * 20);
            if (this.limboCache.hasPlayerData(this.name)) {
                this.limboCache.getPlayerData(this.name).setMessageTask(nextTask);
            }
            return;
        }
    }
}

