/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import fr.xephi.authme.libs.authme.configme.Comment;
import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.PropertyInitializer;
import java.util.List;

public class RegistrationSettings
implements SettingsHolder {
    @Comment(value={"Enable registration on the server?"})
    public static final Property<Boolean> IS_ENABLED = PropertyInitializer.newProperty("settings.registration.enabled", true);
    @Comment(value={"Send every X seconds a message to a player to", "remind him that he has to login/register"})
    public static final Property<Integer> MESSAGE_INTERVAL = PropertyInitializer.newProperty("settings.registration.messageInterval", 5);
    @Comment(value={"Only registered and logged in players can play.", "See restrictions for exceptions"})
    public static final Property<Boolean> FORCE = PropertyInitializer.newProperty("settings.registration.force", true);
    @Comment(value={"Do we replace password registration by an email registration method?"})
    public static final Property<Boolean> USE_EMAIL_REGISTRATION = PropertyInitializer.newProperty("settings.registration.enableEmailRegistrationSystem", false);
    @Comment(value={"Enable double check of email when you register", "when it's true, registration requires that kind of command:", "/register <email> <confirmEmail>"})
    public static final Property<Boolean> ENABLE_CONFIRM_EMAIL = PropertyInitializer.newProperty("settings.registration.doubleEmailCheck", false);
    @Comment(value={"Do we force kick a player after a successful registration?", "Do not use with login feature below"})
    public static final Property<Boolean> FORCE_KICK_AFTER_REGISTER = PropertyInitializer.newProperty("settings.registration.forceKickAfterRegister", false);
    @Comment(value={"Does AuthMe need to enforce a /login after a successful registration?"})
    public static final Property<Boolean> FORCE_LOGIN_AFTER_REGISTER = PropertyInitializer.newProperty("settings.registration.forceLoginAfterRegister", false);
    @Comment(value={"Force these commands after /login, without any '/', use %p to replace with player name"})
    public static final Property<List<String>> FORCE_COMMANDS = PropertyInitializer.newListProperty("settings.forceCommands", new String[0]);
    @Comment(value={"Force these commands after /login as service console, without any '/'. Use %p to replace with player name"})
    public static final Property<List<String>> FORCE_COMMANDS_AS_CONSOLE = PropertyInitializer.newListProperty("settings.forceCommandsAsConsole", new String[0]);
    @Comment(value={"Force these commands after /register, without any '/', use %p to replace with player name"})
    public static final Property<List<String>> FORCE_REGISTER_COMMANDS = PropertyInitializer.newListProperty("settings.forceRegisterCommands", new String[0]);
    @Comment(value={"Force these commands after /register as a server console, without any '/'. Use %p to replace with player name"})
    public static final Property<List<String>> FORCE_REGISTER_COMMANDS_AS_CONSOLE = PropertyInitializer.newListProperty("settings.forceRegisterCommandsAsConsole", new String[0]);
    @Comment(value={"Enable to display the welcome message (welcome.txt) after a login", "You can use colors in this welcome.txt + some replaced strings:", "{PLAYER}: player name, {ONLINE}: display number of online players, {MAXPLAYERS}: display server slots,", "{IP}: player ip, {LOGINS}: number of players logged, {WORLD}: player current world, {SERVER}: server name", "{VERSION}: get current bukkit version, {COUNTRY}: player country"})
    public static final Property<Boolean> USE_WELCOME_MESSAGE = PropertyInitializer.newProperty("settings.useWelcomeMessage", true);
    @Comment(value={"Do we need to broadcast the welcome message to all server or only to the player? set true for server or false for player"})
    public static final Property<Boolean> BROADCAST_WELCOME_MESSAGE = PropertyInitializer.newProperty("settings.broadcastWelcomeMessage", false);
    @Comment(value={"Should we delay the join message and display it once the player has logged in?"})
    public static final Property<Boolean> DELAY_JOIN_MESSAGE = PropertyInitializer.newProperty("settings.delayJoinMessage", false);
    @Comment(value={"Should we remove the leave messages of unlogged users?"})
    public static final Property<Boolean> REMOVE_UNLOGGED_LEAVE_MESSAGE = PropertyInitializer.newProperty("settings.removeUnloggedLeaveMessage", false);
    @Comment(value={"Should we remove join messages altogether?"})
    public static final Property<Boolean> REMOVE_JOIN_MESSAGE = PropertyInitializer.newProperty("settings.removeJoinMessage", false);
    @Comment(value={"Should we remove leave messages altogether?"})
    public static final Property<Boolean> REMOVE_LEAVE_MESSAGE = PropertyInitializer.newProperty("settings.removeLeaveMessage", false);
    @Comment(value={"Do we need to add potion effect Blinding before login/reigster?"})
    public static final Property<Boolean> APPLY_BLIND_EFFECT = PropertyInitializer.newProperty("settings.applyBlindEffect", false);
    @Comment(value={"Do we need to prevent people to login with another case?", "If Xephi is registered, then Xephi can login, but not XEPHI/xephi/XePhI"})
    public static final Property<Boolean> PREVENT_OTHER_CASE = PropertyInitializer.newProperty("settings.preventOtherCase", false);

    private RegistrationSettings() {
    }
}

