/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import fr.xephi.authme.libs.authme.configme.Comment;
import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.PropertyInitializer;
import java.util.List;

public class ProtectionSettings
implements SettingsHolder {
    @Comment(value={"Enable some servers protection (country based login, antibot)"})
    public static final Property<Boolean> ENABLE_PROTECTION = PropertyInitializer.newProperty("Protection.enableProtection", false);
    @Comment(value={"Apply the protection also to registered usernames"})
    public static final Property<Boolean> ENABLE_PROTECTION_REGISTERED = PropertyInitializer.newProperty("Protection.enableProtectionRegistered", true);
    @Comment(value={"Countries allowed to join the server and register, see http://dev.bukkit.org/bukkit-plugins/authme-reloaded/pages/countries-codes/ for countries' codes", "PLEASE USE QUOTES!"})
    public static final Property<List<String>> COUNTRIES_WHITELIST = PropertyInitializer.newListProperty("Protection.countries", "US", "GB");
    @Comment(value={"Countries not allowed to join the server and register", "PLEASE USE QUOTES!"})
    public static final Property<List<String>> COUNTRIES_BLACKLIST = PropertyInitializer.newListProperty("Protection.countriesBlacklist", "A1");
    @Comment(value={"Do we need to enable automatic antibot system?"})
    public static final Property<Boolean> ENABLE_ANTIBOT = PropertyInitializer.newProperty("Protection.enableAntiBot", true);
    @Comment(value={"Max number of players allowed to login in 5 secs before the AntiBot system is enabled automatically"})
    public static final Property<Integer> ANTIBOT_SENSIBILITY = PropertyInitializer.newProperty("Protection.antiBotSensibility", 10);
    @Comment(value={"Duration in minutes of the antibot automatic system"})
    public static final Property<Integer> ANTIBOT_DURATION = PropertyInitializer.newProperty("Protection.antiBotDuration", 10);

    private ProtectionSettings() {
    }
}

