/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import fr.xephi.authme.libs.authme.configme.Comment;
import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.PropertyInitializer;
import fr.xephi.authme.output.LogLevel;

public class PluginSettings
implements SettingsHolder {
    @Comment(value={"The name shown in the help messages"})
    public static final Property<String> HELP_HEADER = PropertyInitializer.newProperty("settings.helpHeader", "AuthMeReloaded");
    @Comment(value={"Do you want to enable the session feature?", "If enabled, when a player authenticates successfully,", "his IP and his nickname is saved.", "The next time the player joins the server, if his IP", "is the same as last time and the timeout hasn't", "expired, he will not need to authenticate."})
    public static final Property<Boolean> SESSIONS_ENABLED = PropertyInitializer.newProperty("settings.sessions.enabled", false);
    @Comment(value={"After how many minutes should a session expire?", "Remember that sessions will end only after the timeout, and", "if the player's IP has changed but the timeout hasn't expired,", "the player will be kicked from the server due to invalid session"})
    public static final Property<Integer> SESSIONS_TIMEOUT = PropertyInitializer.newProperty("settings.sessions.timeout", 10);
    @Comment(value={"Should the session expire if the player tries to log in with", "another IP address?"})
    public static final Property<Boolean> SESSIONS_EXPIRE_ON_IP_CHANGE = PropertyInitializer.newProperty("settings.sessions.sessionExpireOnIpChange", true);
    @Comment(value={"Message language, available: en, de, br, cz, pl, fr, ru, hu, sk, es, zhtw, fi, zhcn, lt, it, ko, pt"})
    public static final Property<String> MESSAGES_LANGUAGE = PropertyInitializer.newProperty("settings.messagesLanguage", "en");
    @Comment(value={"Take care with this option; if you want", "to use group switching of AuthMe", "for unloggedIn players, set this setting to true.", "Default is false."})
    public static final Property<Boolean> ENABLE_PERMISSION_CHECK = PropertyInitializer.newProperty("permission.EnablePermissionCheck", false);
    @Comment(value={"Keeps collisions disabled for logged players", "Works only with MC 1.9"})
    public static final Property<Boolean> KEEP_COLLISIONS_DISABLED = PropertyInitializer.newProperty("settings.restrictions.keepCollisionsDisabled", false);
    @Comment(value={"Log level: INFO, FINE, DEBUG. Use INFO for general messages,", "FINE for some additional detailed ones (like password failed),", "and DEBUG for debugging"})
    public static final Property<LogLevel> LOG_LEVEL = PropertyInitializer.newProperty(LogLevel.class, "settings.logLevel", LogLevel.FINE);
    @Comment(value={"By default we schedule async tasks when talking to the database", "If you want typical communication with the database to happen synchronously, set this to false"})
    public static final Property<Boolean> USE_ASYNC_TASKS = PropertyInitializer.newProperty("settings.useAsyncTasks", true);

    private PluginSettings() {
    }
}

