/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings.properties;

import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.libs.authme.configme.Comment;
import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.PropertyInitializer;

public class DatabaseSettings
implements SettingsHolder {
    @Comment(value={"What type of database do you want to use?", "Valid values: sqlite, mysql"})
    public static final Property<DataSourceType> BACKEND = PropertyInitializer.newProperty(DataSourceType.class, "DataSource.backend", DataSourceType.SQLITE);
    @Comment(value={"Enable database caching, should improve database performance"})
    public static final Property<Boolean> USE_CACHING = PropertyInitializer.newProperty("DataSource.caching", true);
    @Comment(value={"Database host address"})
    public static final Property<String> MYSQL_HOST = PropertyInitializer.newProperty("DataSource.mySQLHost", "127.0.0.1");
    @Comment(value={"Database port"})
    public static final Property<String> MYSQL_PORT = PropertyInitializer.newProperty("DataSource.mySQLPort", "3306");
    @Comment(value={"Username about Database Connection Infos"})
    public static final Property<String> MYSQL_USERNAME = PropertyInitializer.newProperty("DataSource.mySQLUsername", "authme");
    @Comment(value={"Password about Database Connection Infos"})
    public static final Property<String> MYSQL_PASSWORD = PropertyInitializer.newProperty("DataSource.mySQLPassword", "12345");
    @Comment(value={"Database Name, use with converters or as SQLITE database name"})
    public static final Property<String> MYSQL_DATABASE = PropertyInitializer.newProperty("DataSource.mySQLDatabase", "authme");
    @Comment(value={"Table of the database"})
    public static final Property<String> MYSQL_TABLE = PropertyInitializer.newProperty("DataSource.mySQLTablename", "authme");
    @Comment(value={"Column of IDs to sort data"})
    public static final Property<String> MYSQL_COL_ID = PropertyInitializer.newProperty("DataSource.mySQLColumnId", "id");
    @Comment(value={"Column for storing or checking players nickname"})
    public static final Property<String> MYSQL_COL_NAME = PropertyInitializer.newProperty("DataSource.mySQLColumnName", "username");
    @Comment(value={"Column for storing or checking players RealName"})
    public static final Property<String> MYSQL_COL_REALNAME = PropertyInitializer.newProperty("DataSource.mySQLRealName", "realname");
    @Comment(value={"Column for storing players passwords"})
    public static final Property<String> MYSQL_COL_PASSWORD = PropertyInitializer.newProperty("DataSource.mySQLColumnPassword", "password");
    @Comment(value={"Column for storing players passwords salts"})
    public static final Property<String> MYSQL_COL_SALT = PropertyInitializer.newProperty("ExternalBoardOptions.mySQLColumnSalt", "");
    @Comment(value={"Column for storing players emails"})
    public static final Property<String> MYSQL_COL_EMAIL = PropertyInitializer.newProperty("DataSource.mySQLColumnEmail", "email");
    @Comment(value={"Column for storing if a player is logged in or not"})
    public static final Property<String> MYSQL_COL_ISLOGGED = PropertyInitializer.newProperty("DataSource.mySQLColumnLogged", "isLogged");
    @Comment(value={"Column for storing players ips"})
    public static final Property<String> MYSQL_COL_IP = PropertyInitializer.newProperty("DataSource.mySQLColumnIp", "ip");
    @Comment(value={"Column for storing players lastlogins"})
    public static final Property<String> MYSQL_COL_LASTLOGIN = PropertyInitializer.newProperty("DataSource.mySQLColumnLastLogin", "lastlogin");
    @Comment(value={"Column for storing player LastLocation - X"})
    public static final Property<String> MYSQL_COL_LASTLOC_X = PropertyInitializer.newProperty("DataSource.mySQLlastlocX", "x");
    @Comment(value={"Column for storing player LastLocation - Y"})
    public static final Property<String> MYSQL_COL_LASTLOC_Y = PropertyInitializer.newProperty("DataSource.mySQLlastlocY", "y");
    @Comment(value={"Column for storing player LastLocation - Z"})
    public static final Property<String> MYSQL_COL_LASTLOC_Z = PropertyInitializer.newProperty("DataSource.mySQLlastlocZ", "z");
    @Comment(value={"Column for storing player LastLocation - World Name"})
    public static final Property<String> MYSQL_COL_LASTLOC_WORLD = PropertyInitializer.newProperty("DataSource.mySQLlastlocWorld", "world");
    @Comment(value={"Column for storing players groups"})
    public static final Property<String> MYSQL_COL_GROUP = PropertyInitializer.newProperty("ExternalBoardOptions.mySQLColumnGroup", "");

    private DatabaseSettings() {
    }
}

