/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SpawnLoader
implements Reloadable {
    private final File authMeConfigurationFile;
    private final Settings settings;
    private final PluginHooks pluginHooks;
    private FileConfiguration authMeConfiguration;
    private String[] spawnPriority;
    private Location essentialsSpawn;

    @Inject
    SpawnLoader(@DataFolder File pluginFolder, Settings settings, PluginHooks pluginHooks, DataSource dataSource) {
        File spawnFile = new File(pluginFolder, "spawn.yml");
        FileUtils.copyFileFromResource(spawnFile, "spawn.yml");
        this.authMeConfigurationFile = new File(pluginFolder, "spawn.yml");
        this.settings = settings;
        this.pluginHooks = pluginHooks;
        this.reload();
    }

    @Override
    public void reload() {
        this.spawnPriority = this.settings.getProperty(RestrictionSettings.SPAWN_PRIORITY).split(",");
        this.authMeConfiguration = YamlConfiguration.loadConfiguration((File)this.authMeConfigurationFile);
        this.loadEssentialsSpawn();
    }

    public Location getSpawn() {
        return SpawnLoader.getLocationFromConfiguration(this.authMeConfiguration, "spawn");
    }

    public boolean setSpawn(Location location) {
        return this.setLocation("spawn", location);
    }

    public Location getFirstSpawn() {
        return SpawnLoader.getLocationFromConfiguration(this.authMeConfiguration, "firstspawn");
    }

    public boolean setFirstSpawn(Location location) {
        return this.setLocation("firstspawn", location);
    }

    public void loadEssentialsSpawn() {
        File essentialsFolder = this.pluginHooks.getEssentialsDataFolder();
        if (essentialsFolder == null) {
            return;
        }
        File essentialsSpawnFile = new File(essentialsFolder, "spawn.yml");
        if (essentialsSpawnFile.exists()) {
            this.essentialsSpawn = SpawnLoader.getLocationFromConfiguration((FileConfiguration)YamlConfiguration.loadConfiguration((File)essentialsSpawnFile), "spawns.default");
        } else {
            this.essentialsSpawn = null;
            ConsoleLogger.info("Essentials spawn file not found: '" + essentialsSpawnFile.getAbsolutePath() + "'");
        }
    }

    public void unloadEssentialsSpawn() {
        this.essentialsSpawn = null;
    }

    public Location getSpawnLocation(Player player) {
        if (player == null || player.getWorld() == null) {
            return null;
        }
        World world = player.getWorld();
        Location spawnLoc = null;
        for (String priority : this.spawnPriority) {
            switch (priority.toLowerCase().trim()) {
                case "default": {
                    if (world.getSpawnLocation() == null) break;
                    spawnLoc = world.getSpawnLocation();
                    break;
                }
                case "multiverse": {
                    if (!this.settings.getProperty(HooksSettings.MULTIVERSE).booleanValue()) break;
                    spawnLoc = this.pluginHooks.getMultiverseSpawn(world);
                    break;
                }
                case "essentials": {
                    spawnLoc = this.essentialsSpawn;
                    break;
                }
                case "authme": {
                    spawnLoc = this.getSpawn();
                }
            }
            if (spawnLoc == null) continue;
            return spawnLoc;
        }
        return world.getSpawnLocation();
    }

    private boolean setLocation(String prefix, Location location) {
        if (location != null && location.getWorld() != null) {
            this.authMeConfiguration.set(prefix + ".world", (Object)location.getWorld().getName());
            this.authMeConfiguration.set(prefix + ".x", (Object)location.getX());
            this.authMeConfiguration.set(prefix + ".y", (Object)location.getY());
            this.authMeConfiguration.set(prefix + ".z", (Object)location.getZ());
            this.authMeConfiguration.set(prefix + ".yaw", (Object)Float.valueOf(location.getYaw()));
            this.authMeConfiguration.set(prefix + ".pitch", (Object)Float.valueOf(location.getPitch()));
            return this.saveAuthMeConfig();
        }
        return false;
    }

    private boolean saveAuthMeConfig() {
        try {
            this.authMeConfiguration.save(this.authMeConfigurationFile);
            return true;
        }
        catch (IOException e) {
            ConsoleLogger.logException("Could not save spawn config (" + this.authMeConfigurationFile + ")", e);
            return false;
        }
    }

    public Location getPlayerLocationOrSpawn(Player player) {
        if (player.isOnline() && player.isDead()) {
            return this.getSpawnLocation(player);
        }
        return player.getLocation();
    }

    private static Location getLocationFromConfiguration(FileConfiguration configuration, String pathPrefix) {
        if (SpawnLoader.containsAllSpawnFields(configuration, pathPrefix)) {
            String prefix = pathPrefix + ".";
            String worldName = configuration.getString(prefix + "world");
            World world = Bukkit.getWorld((String)worldName);
            if (!StringUtils.isEmpty(worldName) && world != null) {
                return new Location(world, configuration.getDouble(prefix + "x"), configuration.getDouble(prefix + "y"), configuration.getDouble(prefix + "z"), SpawnLoader.getFloat(configuration, prefix + "yaw"), SpawnLoader.getFloat(configuration, prefix + "pitch"));
            }
        }
        return null;
    }

    private static boolean containsAllSpawnFields(FileConfiguration configuration, String pathPrefix) {
        String[] fields;
        for (String field : fields = new String[]{"world", "x", "y", "z", "yaw", "pitch"}) {
            if (configuration.contains(pathPrefix + "." + field)) continue;
            return false;
        }
        return true;
    }

    private static float getFloat(FileConfiguration configuration, String path) {
        Object value = configuration.get(path);
        return value instanceof Number ? ((Number)value).floatValue() : 0.0f;
    }
}

