/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import com.google.common.base.Objects;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.migration.PlainMigrationService;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.PropertyInitializer;
import fr.xephi.authme.libs.authme.configme.resource.PropertyResource;
import fr.xephi.authme.output.LogLevel;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class SettingsMigrationService
extends PlainMigrationService {
    private final File pluginFolder;

    public SettingsMigrationService(File pluginFolder) {
        this.pluginFolder = pluginFolder;
    }

    @Override
    protected boolean performMigrations(PropertyResource resource, List<PropertyEntry> knownProperties) {
        boolean changes = false;
        if ("[a-zA-Z0-9_?]*".equals(resource.getString(RestrictionSettings.ALLOWED_NICKNAME_CHARACTERS.getPath()))) {
            resource.setValue(RestrictionSettings.ALLOWED_NICKNAME_CHARACTERS.getPath(), "[a-zA-Z0-9_]*");
            changes = true;
        }
        return changes | this.performMailTextToFileMigration(resource) | SettingsMigrationService.migrateJoinLeaveMessages(resource) | SettingsMigrationService.migrateForceSpawnSettings(resource) | SettingsMigrationService.changeBooleanSettingToLogLevelProperty(resource) || SettingsMigrationService.hasDeprecatedProperties(resource);
    }

    private static boolean hasDeprecatedProperties(PropertyResource resource) {
        String[] deprecatedProperties;
        for (String deprecatedPath : deprecatedProperties = new String[]{"Converter.Rakamak.newPasswordHash", "Hooks.chestshop", "Hooks.legacyChestshop", "Hooks.notifications", "Passpartu", "Performances", "settings.restrictions.enablePasswordVerifier", "Xenoforo.predefinedSalt", "VeryGames", "settings.restrictions.allowAllCommandsIfRegistrationIsOptional", "DataSource.mySQLWebsite", "Hooks.customAttributes", "Security.stop.kickPlayersBeforeStopping"}) {
            if (!resource.contains(deprecatedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean performMailTextToFileMigration(PropertyResource resource) {
        String oldSettingPath = "Email.mailText";
        String oldMailText = resource.getString("Email.mailText");
        if (oldMailText == null) {
            return false;
        }
        File emailFile = new File(this.pluginFolder, "email.html");
        String mailText = oldMailText.replace("<playername>", "<playername />").replace("%playername%", "<playername />").replace("<servername>", "<servername />").replace("%servername%", "<servername />").replace("<generatedpass>", "<generatedpass />").replace("%generatedpass%", "<generatedpass />").replace("<image>", "<image />").replace("%image%", "<image />");
        if (!emailFile.exists()) {
            try (FileWriter fw = new FileWriter(emailFile);){
                fw.write(mailText);
            }
            catch (IOException e) {
                ConsoleLogger.logException("Could not create email.html configuration file:", e);
            }
        }
        return true;
    }

    private static boolean migrateJoinLeaveMessages(PropertyResource resource) {
        Property<Boolean> oldDelayJoinProperty = PropertyInitializer.newProperty("settings.delayJoinLeaveMessages", false);
        boolean hasMigrated = SettingsMigrationService.moveProperty(oldDelayJoinProperty, RegistrationSettings.DELAY_JOIN_MESSAGE, resource);
        if (hasMigrated) {
            ConsoleLogger.info(String.format("Note that we now also have the settings %s and %s", RegistrationSettings.REMOVE_JOIN_MESSAGE.getPath(), RegistrationSettings.REMOVE_LEAVE_MESSAGE.getPath()));
        }
        return hasMigrated;
    }

    private static boolean migrateForceSpawnSettings(PropertyResource resource) {
        Property<Boolean> oldForceLocEnabled = PropertyInitializer.newProperty("settings.restrictions.ForceSpawnLocOnJoinEnabled", false);
        Property<List<String>> oldForceWorlds = PropertyInitializer.newListProperty("settings.restrictions.ForceSpawnOnTheseWorlds", "world", "world_nether", "world_the_ed");
        return SettingsMigrationService.moveProperty(oldForceLocEnabled, RestrictionSettings.FORCE_SPAWN_LOCATION_AFTER_LOGIN, resource) | SettingsMigrationService.moveProperty(oldForceWorlds, RestrictionSettings.FORCE_SPAWN_ON_WORLDS, resource);
    }

    private static boolean changeBooleanSettingToLogLevelProperty(PropertyResource resource) {
        String oldPath = "Security.console.noConsoleSpam";
        Property<LogLevel> newProperty = PluginSettings.LOG_LEVEL;
        if (!newProperty.isPresent(resource) && resource.contains("Security.console.noConsoleSpam")) {
            ConsoleLogger.info("Moving 'Security.console.noConsoleSpam' to '" + newProperty.getPath() + "'");
            boolean oldValue = (Boolean)Objects.firstNonNull((Object)resource.getBoolean("Security.console.noConsoleSpam"), (Object)false);
            LogLevel level = oldValue ? LogLevel.INFO : LogLevel.FINE;
            resource.setValue(newProperty.getPath(), level.name());
            return true;
        }
        return false;
    }

    private static <T> boolean moveProperty(Property<T> oldProperty, Property<T> newProperty, PropertyResource resource) {
        if (resource.contains(oldProperty.getPath())) {
            ConsoleLogger.info("Detected deprecated property " + oldProperty.getPath());
            if (!resource.contains(newProperty.getPath())) {
                ConsoleLogger.info("Renamed " + oldProperty.getPath() + " to " + newProperty.getPath());
                resource.setValue(newProperty.getPath(), oldProperty.getValue(resource));
            }
            return true;
        }
        return false;
    }
}

