/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.settings;

import com.google.common.io.Files;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.libs.authme.configme.SettingsManager;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.migration.MigrationService;
import fr.xephi.authme.libs.authme.configme.resource.PropertyResource;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class Settings
extends SettingsManager {
    private final File pluginFolder;
    private File messagesFile;
    private String[] welcomeMessage;
    private String passwordEmailMessage;
    private String recoveryCodeEmailMessage;

    public Settings(File pluginFolder, PropertyResource resource, MigrationService migrationService, List<PropertyEntry> knownProperties) {
        super(resource, migrationService, knownProperties);
        this.pluginFolder = pluginFolder;
        this.loadSettingsFromFiles();
    }

    public File getMessagesFile() {
        return this.messagesFile;
    }

    public String getDefaultMessagesFile() {
        return "/messages/messages_en.yml";
    }

    public String getPasswordEmailMessage() {
        return this.passwordEmailMessage;
    }

    public String getRecoveryCodeEmailMessage() {
        return this.recoveryCodeEmailMessage;
    }

    public String[] getWelcomeMessage() {
        return this.welcomeMessage;
    }

    private void loadSettingsFromFiles() {
        this.messagesFile = this.buildMessagesFile();
        this.passwordEmailMessage = this.readFile("email.html");
        this.recoveryCodeEmailMessage = this.readFile("recovery_code_email.html");
        this.welcomeMessage = this.readFile("welcome.txt").split("\n");
    }

    @Override
    public void reload() {
        super.reload();
        this.loadSettingsFromFiles();
    }

    private File buildMessagesFile() {
        String languageCode = this.getProperty(PluginSettings.MESSAGES_LANGUAGE);
        String filePath = Settings.buildMessagesFilePathFromCode(languageCode);
        File messagesFile = new File(this.pluginFolder, filePath);
        if (FileUtils.copyFileFromResource(messagesFile, filePath)) {
            return messagesFile;
        }
        String defaultFilePath = Settings.buildMessagesFilePathFromCode("en");
        File defaultFile = new File(this.pluginFolder, defaultFilePath);
        FileUtils.copyFileFromResource(defaultFile, defaultFilePath);
        return defaultFile;
    }

    private static String buildMessagesFilePathFromCode(String language) {
        return StringUtils.makePath("messages", "messages_" + language + ".yml");
    }

    private String readFile(String filename) {
        File file = new File(this.pluginFolder, filename);
        if (FileUtils.copyFileFromResource(file, filename)) {
            try {
                return Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                ConsoleLogger.logException("Failed to read file '" + filename + "':", e);
            }
        } else {
            ConsoleLogger.warning("Failed to copy file '" + filename + "' from JAR");
        }
        return "";
    }
}

