/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecoveryCodeManager
implements SettingsDependent {
    private Map<String, ExpiringEntry> recoveryCodes = new ConcurrentHashMap<String, ExpiringEntry>();
    private int recoveryCodeLength;
    private long recoveryCodeExpirationMillis;

    @Inject
    RecoveryCodeManager(Settings settings) {
        this.reload(settings);
    }

    public boolean isRecoveryCodeNeeded() {
        return this.recoveryCodeLength > 0 && this.recoveryCodeExpirationMillis > 0L;
    }

    public String generateCode(String player) {
        String code = RandomString.generateHex(this.recoveryCodeLength);
        this.recoveryCodes.put(player, new ExpiringEntry(code, System.currentTimeMillis() + this.recoveryCodeExpirationMillis));
        return code;
    }

    public boolean isCodeValid(String player, String code) {
        ExpiringEntry entry = this.recoveryCodes.get(player);
        if (entry != null) {
            return code != null && code.equals(entry.getCode());
        }
        return false;
    }

    public void removeCode(String player) {
        this.recoveryCodes.remove(player);
    }

    @Override
    public void reload(Settings settings) {
        this.recoveryCodeLength = settings.getProperty(SecuritySettings.RECOVERY_CODE_LENGTH);
        this.recoveryCodeExpirationMillis = (long)settings.getProperty(SecuritySettings.RECOVERY_CODE_HOURS_VALID).intValue() * 3600000L;
    }

    @VisibleForTesting
    static final class ExpiringEntry {
        private final String code;
        private final long expiration;

        ExpiringEntry(String code, long expiration) {
            this.code = code;
            this.expiration = expiration;
        }

        String getCode() {
            return System.currentTimeMillis() < this.expiration ? this.code : null;
        }
    }
}

