/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.service;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;

public class BungeeService
implements SettingsDependent {
    private AuthMe plugin;
    private boolean isEnabled;
    private String bungeeServer;

    @Inject
    BungeeService(AuthMe plugin, Settings settings) {
        this.plugin = plugin;
        this.reload(settings);
    }

    public void connectPlayer(Player player) {
        if (!this.isEnabled || this.bungeeServer.isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(this.bungeeServer);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
    }

    @Override
    public void reload(Settings settings) {
        this.isEnabled = settings.getProperty(HooksSettings.BUNGEECORD);
        this.bungeeServer = settings.getProperty(HooksSettings.BUNGEECORD_SERVER);
        Messenger messenger = this.plugin.getServer().getMessenger();
        if (!this.isEnabled) {
            return;
        }
        if (!messenger.isOutgoingChannelRegistered((Plugin)this.plugin, "BungeeCord")) {
            messenger.registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
        }
    }
}

