/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.HexSaltedMethod;
import fr.xephi.authme.security.crypts.WHIRLPOOL;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.Usage;

@Recommendation(value=Usage.RECOMMENDED)
public class XAUTH
extends HexSaltedMethod {
    private static String getWhirlpool(String message) {
        WHIRLPOOL w = new WHIRLPOOL();
        byte[] digest = new byte[64];
        w.NESSIEinit();
        w.NESSIEadd(message);
        w.NESSIEfinalize(digest);
        return WHIRLPOOL.display(digest);
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        String hash = XAUTH.getWhirlpool(salt + password).toLowerCase();
        int saltPos = password.length() >= hash.length() ? hash.length() - 1 : password.length();
        return hash.substring(0, saltPos) + salt + hash.substring(saltPos);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String playerName) {
        int saltPos;
        String hash = hashedPassword.getHash();
        int n = saltPos = password.length() >= hash.length() ? hash.length() - 1 : password.length();
        if (saltPos + 12 > hash.length()) {
            return false;
        }
        String salt = hash.substring(saltPos, saltPos + 12);
        return hash.equals(this.computeHash(password, salt, null));
    }

    @Override
    public int getSaltLength() {
        return 12;
    }
}

