/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.crypts.BCryptService;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.HexSaltedMethod;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.Usage;

@Recommendation(value=Usage.RECOMMENDED)
public class WBB4
extends HexSaltedMethod {
    @Override
    public String computeHash(String password, String salt, String name) {
        return BCryptService.hashpw(BCryptService.hashpw(password, salt), salt);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String playerName) {
        if (hashedPassword.getHash().length() != 60) {
            return false;
        }
        String salt = hashedPassword.getHash().substring(0, 29);
        return this.computeHash(password, salt, null).equals(hashedPassword.getHash());
    }

    @Override
    public String generateSalt() {
        return BCryptService.gensalt(8);
    }

    @Override
    public int getSaltLength() {
        return 8;
    }
}

