/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.security.crypts.SeparateSaltMethod;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;

@Recommendation(value=Usage.ACCEPTABLE)
@HasSalt(value=SaltType.TEXT)
public class SALTED2MD5
extends SeparateSaltMethod {
    private final int saltLength;

    @Inject
    public SALTED2MD5(Settings settings) {
        this.saltLength = settings.getProperty(SecuritySettings.DOUBLE_MD5_SALT_LENGTH);
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        return HashUtils.md5(HashUtils.md5(password) + salt);
    }

    @Override
    public String generateSalt() {
        return RandomString.generateHex(this.saltLength);
    }
}

