/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.MessageDigestAlgorithm;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.HexSaltedMethod;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class PHPBB
extends HexSaltedMethod {
    private static final String itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private static String md5(String data) {
        try {
            byte[] bytes = data.getBytes("ISO-8859-1");
            MessageDigest md5er = HashUtils.getDigest(MessageDigestAlgorithm.MD5);
            byte[] hash = md5er.digest(bytes);
            return PHPBB.bytes2hex(hash);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static int hexToInt(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if ((ch = Character.toUpperCase(ch)) >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex character: " + ch);
    }

    private static String bytes2hex(byte[] bytes) {
        StringBuilder r = new StringBuilder(32);
        for (byte b : bytes) {
            String x = Integer.toHexString(b & 0xFF);
            if (x.length() < 2) {
                r.append('0');
            }
            r.append(x);
        }
        return r.toString();
    }

    private static String pack(String hex) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            char c1 = hex.charAt(i);
            char c2 = hex.charAt(i + 1);
            char packed = (char)(PHPBB.hexToInt(c1) * 16 + PHPBB.hexToInt(c2));
            buf.append(packed);
        }
        return buf.toString();
    }

    private String phpbb_hash(String password, String salt) {
        String random_state = salt;
        StringBuilder random = new StringBuilder();
        int count = 6;
        for (int i = 0; i < count; i += 16) {
            random_state = PHPBB.md5(salt + random_state);
            random.append(PHPBB.pack(PHPBB.md5(random_state)));
        }
        String hash = this._hash_crypt_private(password, this._hash_gensalt_private(random.substring(0, count), itoa64));
        if (hash.length() == 34) {
            return hash;
        }
        return PHPBB.md5(password);
    }

    private String _hash_gensalt_private(String input, String itoa64) {
        return this._hash_gensalt_private(input, itoa64, 6);
    }

    private String _hash_gensalt_private(String input, String itoa64, int iteration_count_log2) {
        if (iteration_count_log2 < 4 || iteration_count_log2 > 31) {
            iteration_count_log2 = 8;
        }
        String output = "$H$";
        output = output + itoa64.charAt(Math.min(iteration_count_log2 + 3, 30));
        output = output + this._hash_encode64(input, 6);
        return output;
    }

    private String _hash_encode64(String input, int count) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        do {
            int value = input.charAt(i++);
            output.append(itoa64.charAt(value & 0x3F));
            if (i < count) {
                value |= input.charAt(i) << 8;
            }
            output.append(itoa64.charAt(value >> 6 & 0x3F));
            if (i++ >= count) break;
            if (i < count) {
                value |= input.charAt(i) << 16;
            }
            output.append(itoa64.charAt(value >> 12 & 0x3F));
            if (i++ >= count) break;
            output.append(itoa64.charAt(value >> 18 & 0x3F));
        } while (i < count);
        return output.toString();
    }

    private String _hash_crypt_private(String password, String setting) {
        String output = "*";
        if (!setting.substring(0, 3).equals("$H$")) {
            return output;
        }
        int count_log2 = itoa64.indexOf(setting.charAt(3));
        if (count_log2 < 7 || count_log2 > 30) {
            return output;
        }
        int count = 1 << count_log2;
        String salt = setting.substring(4, 12);
        if (salt.length() != 8) {
            return output;
        }
        String m1 = PHPBB.md5(salt + password);
        String hash = PHPBB.pack(m1);
        do {
            hash = PHPBB.pack(PHPBB.md5(hash + password));
        } while (--count > 0);
        output = setting.substring(0, 12);
        output = output + this._hash_encode64(hash, 16);
        return output;
    }

    private boolean phpbb_check_hash(String password, String hash) {
        if (hash.length() == 34) {
            return this._hash_crypt_private(password, hash).equals(hash);
        }
        return PHPBB.md5(password).equals(hash);
    }

    @Override
    public String computeHash(String password, String salt, String name) {
        return this.phpbb_hash(password, salt);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String name) {
        return this.phpbb_check_hash(password, hashedPassword.getHash());
    }

    @Override
    public int getSaltLength() {
        return 16;
    }
}

