/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.security.HashUtils;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.security.crypts.BCryptService;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.description.HasSalt;
import fr.xephi.authme.security.crypts.description.Recommendation;
import fr.xephi.authme.security.crypts.description.SaltType;
import fr.xephi.authme.security.crypts.description.Usage;
import fr.xephi.authme.util.StringUtils;

@Recommendation(value=Usage.DOES_NOT_WORK)
@HasSalt(value=SaltType.TEXT, length=22)
public class IPB4
implements EncryptionMethod {
    @Override
    public String computeHash(String password, String salt, String name) {
        return BCryptService.hashpw(password, "$2a$13$" + salt);
    }

    @Override
    public HashedPassword computeHash(String password, String name) {
        String salt = this.generateSalt();
        return new HashedPassword(this.computeHash(password, salt, name), salt);
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hash, String name) {
        try {
            return HashUtils.isValidBcryptHash(hash.getHash()) && BCryptService.checkpw(password, hash.getHash());
        }
        catch (IllegalArgumentException e) {
            ConsoleLogger.warning("Bcrypt checkpw() returned " + StringUtils.formatException(e));
            return false;
        }
    }

    @Override
    public String generateSalt() {
        return RandomString.generateLowerUpper(22);
    }

    @Override
    public boolean hasSeparateSalt() {
        return true;
    }
}

