/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security.crypts;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.HexSaltedMethod;
import fr.xephi.authme.security.crypts.description.AsciiRestricted;
import fr.xephi.authme.security.pbkdf2.PBKDF2Engine;
import fr.xephi.authme.security.pbkdf2.PBKDF2Parameters;
import fr.xephi.authme.util.StringUtils;
import javax.xml.bind.DatatypeConverter;

@AsciiRestricted
public class CryptPBKDF2Django
extends HexSaltedMethod {
    private static final int DEFAULT_ITERATIONS = 24000;

    @Override
    public String computeHash(String password, String salt, String name) {
        String result = "pbkdf2_sha256$24000$" + salt + "$";
        PBKDF2Parameters params = new PBKDF2Parameters("HmacSHA256", "ASCII", salt.getBytes(), 24000);
        PBKDF2Engine engine = new PBKDF2Engine(params);
        return result + String.valueOf(DatatypeConverter.printBase64Binary((byte[])engine.deriveKey(password, 32)));
    }

    @Override
    public boolean comparePassword(String password, HashedPassword hashedPassword, String unusedName) {
        int iterations;
        String[] line = hashedPassword.getHash().split("\\$");
        if (line.length != 4) {
            return false;
        }
        try {
            iterations = Integer.parseInt(line[1]);
        }
        catch (NumberFormatException e) {
            ConsoleLogger.warning("Could not read number of rounds for CryptPBKDF2Django:" + StringUtils.formatException(e));
            return false;
        }
        String salt = line[2];
        byte[] derivedKey = DatatypeConverter.parseBase64Binary((String)line[3]);
        PBKDF2Parameters params = new PBKDF2Parameters("HmacSHA256", "ASCII", salt.getBytes(), iterations, derivedKey);
        PBKDF2Engine engine = new PBKDF2Engine(params);
        return engine.verifyKey(password);
    }

    @Override
    public int getSaltLength() {
        return 12;
    }
}

