/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security;

import java.security.SecureRandom;
import java.util.Random;

public final class RandomString {
    private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new SecureRandom();
    private static final int HEX_MAX_INDEX = 16;
    private static final int LOWER_ALPHANUMERIC_INDEX = 36;

    private RandomString() {
    }

    public static String generate(int length) {
        return RandomString.generate(length, 36);
    }

    public static String generateHex(int length) {
        return RandomString.generate(length, 16);
    }

    public static String generateLowerUpper(int length) {
        return RandomString.generate(length, CHARS.length());
    }

    private static String generate(int length, int maxIndex) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be positive but was " + length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARS.charAt(RANDOM.nextInt(maxIndex)));
        }
        return sb.toString();
    }
}

