/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.security;

import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.PasswordEncryptionEvent;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.crypts.EncryptionMethod;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import javax.annotation.PostConstruct;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public class PasswordSecurity
implements Reloadable {
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private Injector injector;
    private HashAlgorithm algorithm;
    private boolean supportOldAlgorithm;

    @Override
    @PostConstruct
    public void reload() {
        this.algorithm = this.settings.getProperty(SecuritySettings.PASSWORD_HASH);
        this.supportOldAlgorithm = this.settings.getProperty(SecuritySettings.SUPPORT_OLD_PASSWORD_HASH);
    }

    public HashedPassword computeHash(String password, String playerName) {
        String playerLowerCase = playerName.toLowerCase();
        EncryptionMethod method = this.initializeEncryptionMethodWithEvent(this.algorithm, playerLowerCase);
        return method.computeHash(password, playerLowerCase);
    }

    public boolean comparePassword(String password, String playerName) {
        HashedPassword auth = this.dataSource.getPassword(playerName);
        return auth != null && this.comparePassword(password, auth, playerName);
    }

    public boolean comparePassword(String password, HashedPassword hashedPassword, String playerName) {
        String playerLowerCase;
        EncryptionMethod method = this.initializeEncryptionMethodWithEvent(this.algorithm, playerName);
        return PasswordSecurity.methodMatches(method, password, hashedPassword, playerLowerCase = playerName.toLowerCase()) || this.supportOldAlgorithm && this.compareWithAllEncryptionMethods(password, hashedPassword, playerLowerCase);
    }

    private boolean compareWithAllEncryptionMethods(String password, HashedPassword hashedPassword, String playerName) {
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            EncryptionMethod method;
            if (HashAlgorithm.CUSTOM.equals((Object)algorithm) || !PasswordSecurity.methodMatches(method = this.initializeEncryptionMethod(algorithm), password, hashedPassword, playerName)) continue;
            this.hashPasswordForNewAlgorithm(password, playerName);
            return true;
        }
        return false;
    }

    private static boolean methodMatches(EncryptionMethod method, String password, HashedPassword hashedPassword, String playerName) {
        return method != null && (!method.hasSeparateSalt() || hashedPassword.getSalt() != null) && method.comparePassword(password, hashedPassword, playerName);
    }

    private EncryptionMethod initializeEncryptionMethodWithEvent(HashAlgorithm algorithm, String playerName) {
        EncryptionMethod method = this.initializeEncryptionMethod(algorithm);
        PasswordEncryptionEvent event = new PasswordEncryptionEvent(method, playerName);
        this.pluginManager.callEvent((Event)event);
        return event.getMethod();
    }

    private EncryptionMethod initializeEncryptionMethod(HashAlgorithm algorithm) {
        if (HashAlgorithm.CUSTOM.equals((Object)algorithm) || HashAlgorithm.PLAINTEXT.equals((Object)algorithm)) {
            return null;
        }
        return this.injector.newInstance(algorithm.getClazz());
    }

    private void hashPasswordForNewAlgorithm(String password, String playerName) {
        HashedPassword hashedPassword = this.initializeEncryptionMethodWithEvent(this.algorithm, playerName).computeHash(password, playerName);
        this.dataSource.updatePassword(playerName, hashedPassword);
    }
}

