/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.unregister;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AuthGroupHandler;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.TeleportationService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AsynchronousUnregister
implements AsynchronousProcess {
    @Inject
    private DataSource dataSource;
    @Inject
    private ProcessService service;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private LimboCache limboCache;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;
    @Inject
    private TeleportationService teleportationService;
    @Inject
    private AuthGroupHandler authGroupHandler;

    AsynchronousUnregister() {
    }

    public void unregister(Player player, String password) {
        String name = player.getName();
        PlayerAuth cachedAuth = this.playerCache.getAuth(name);
        if (this.passwordSecurity.comparePassword(password, cachedAuth.getPassword(), name)) {
            if (this.dataSource.removeAuth(name)) {
                this.performUnregister(name, player);
                ConsoleLogger.info(name + " unregistered himself");
            } else {
                this.service.send((CommandSender)player, MessageKey.ERROR);
            }
        } else {
            this.service.send((CommandSender)player, MessageKey.WRONG_PASSWORD);
        }
    }

    public void adminUnregister(CommandSender initiator, String name, Player player) {
        if (this.dataSource.removeAuth(name)) {
            this.performUnregister(name, player);
            if (initiator == null) {
                ConsoleLogger.info(name + " was unregistered");
            } else {
                ConsoleLogger.info(name + " was unregistered by " + initiator.getName());
                this.service.send(initiator, MessageKey.UNREGISTERED_SUCCESS);
            }
        } else if (initiator != null) {
            this.service.send(initiator, MessageKey.ERROR);
        }
    }

    private void performUnregister(String name, Player player) {
        this.playerCache.removePlayer(name);
        if (player == null || !player.isOnline()) {
            return;
        }
        if (this.service.getProperty(RegistrationSettings.FORCE).booleanValue()) {
            this.teleportationService.teleportOnJoin(player);
            player.saveData();
            this.limboCache.deletePlayerData(player);
            this.limboCache.addPlayerData(player);
            this.playerDataTaskManager.registerTimeoutTask(player);
            this.playerDataTaskManager.registerMessageTask(name, false);
            this.applyBlindEffect(player);
        }
        this.authGroupHandler.setGroup(player, AuthGroupType.UNREGISTERED);
        this.service.send((CommandSender)player, MessageKey.UNREGISTERED_SUCCESS);
    }

    private void applyBlindEffect(final Player player) {
        if (this.service.getProperty(RegistrationSettings.APPLY_BLIND_EFFECT).booleanValue()) {
            final int timeout = this.service.getProperty(RestrictionSettings.TIMEOUT) * 20;
            this.bukkitService.runTask(new Runnable(){

                @Override
                public void run() {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, timeout, 2));
                }
            });
        }
    }
}

