/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SynchronousProcess;
import fr.xephi.authme.service.BungeeService;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProcessSyncPasswordRegister
implements SynchronousProcess {
    @Inject
    private BungeeService bungeeService;
    @Inject
    private ProcessService service;
    @Inject
    private LimboCache limboCache;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;

    ProcessSyncPasswordRegister() {
    }

    private void forceCommands(Player player) {
        for (String command : this.service.getProperty(RegistrationSettings.FORCE_REGISTER_COMMANDS)) {
            player.performCommand(command.replace("%p", player.getName()));
        }
        for (String command : this.service.getProperty(RegistrationSettings.FORCE_REGISTER_COMMANDS_AS_CONSOLE)) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command.replace("%p", player.getName()));
        }
    }

    private void requestLogin(Player player) {
        String name = player.getName().toLowerCase();
        this.limboCache.updatePlayerData(player);
        this.playerDataTaskManager.registerTimeoutTask(player);
        this.playerDataTaskManager.registerMessageTask(name, true);
        if (player.isInsideVehicle() && player.getVehicle() != null) {
            player.getVehicle().eject();
        }
    }

    public void processPasswordRegister(Player player) {
        if (!this.service.getProperty(HooksSettings.REGISTERED_GROUP).isEmpty()) {
            this.service.setGroup(player, AuthGroupType.REGISTERED);
        }
        this.service.send((CommandSender)player, MessageKey.REGISTER_SUCCESS);
        if (!this.service.getProperty(EmailSettings.MAIL_ACCOUNT).isEmpty()) {
            this.service.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
        }
        player.saveData();
        ConsoleLogger.fine(player.getName() + " registered " + Utils.getPlayerIp(player));
        if (this.service.getProperty(RegistrationSettings.FORCE_KICK_AFTER_REGISTER).booleanValue()) {
            player.kickPlayer(this.service.retrieveSingleMessage(MessageKey.REGISTER_SUCCESS));
            return;
        }
        this.forceCommands(player);
        if (this.service.getProperty(RegistrationSettings.FORCE_LOGIN_AFTER_REGISTER).booleanValue()) {
            this.requestLogin(player);
            return;
        }
        this.bungeeService.connectPlayer(player);
    }
}

