/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SynchronousProcess;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProcessSyncEmailRegister
implements SynchronousProcess {
    @Inject
    private ProcessService service;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;

    ProcessSyncEmailRegister() {
    }

    public void processEmailRegister(Player player) {
        String name = player.getName().toLowerCase();
        if (!this.service.getProperty(HooksSettings.REGISTERED_GROUP).isEmpty()) {
            this.service.setGroup(player, AuthGroupType.REGISTERED);
        }
        this.service.send((CommandSender)player, MessageKey.ACCOUNT_NOT_ACTIVATED);
        this.playerDataTaskManager.registerTimeoutTask(player);
        this.playerDataTaskManager.registerMessageTask(name, true);
        player.saveData();
        ConsoleLogger.fine(player.getName() + " registered " + Utils.getPlayerIp(player));
    }
}

