/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.register;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.mail.SendMailSSL;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.process.login.AsynchronousLogin;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.TwoFactor;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import fr.xephi.authme.util.ValidationService;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsyncRegister
implements AsynchronousProcess {
    private static final int SYNC_LOGIN_DELAY = 5;
    @Inject
    private DataSource database;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private ProcessService service;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private ValidationService validationService;
    @Inject
    private SendMailSSL sendMailSsl;
    @Inject
    private AsynchronousLogin asynchronousLogin;
    @Inject
    private BukkitService bukkitService;

    AsyncRegister() {
    }

    private boolean preRegisterCheck(Player player, String password) {
        List<String> otherAccounts;
        ValidationService.ValidationResult passwordValidation;
        String name = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(name)) {
            this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            return false;
        }
        if (!this.service.getProperty(RegistrationSettings.IS_ENABLED).booleanValue()) {
            this.service.send((CommandSender)player, MessageKey.REGISTRATION_DISABLED);
            return false;
        }
        if (this.service.getProperty(SecuritySettings.PASSWORD_HASH) != HashAlgorithm.TWO_FACTOR && (passwordValidation = this.validationService.validatePassword(password, player.getName())).hasError()) {
            this.service.send((CommandSender)player, passwordValidation.getMessageKey(), passwordValidation.getArgs());
            return false;
        }
        if (this.database.isAuthAvailable(name)) {
            this.service.send((CommandSender)player, MessageKey.NAME_ALREADY_REGISTERED);
            return false;
        }
        int maxRegPerIp = this.service.getProperty(RestrictionSettings.MAX_REGISTRATION_PER_IP);
        String ip = Utils.getPlayerIp(player);
        if (!(maxRegPerIp <= 0 || "127.0.0.1".equalsIgnoreCase(ip) || "localhost".equalsIgnoreCase(ip) || this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) || (otherAccounts = this.database.getAllAuthsByIp(ip)).size() < maxRegPerIp)) {
            this.service.send((CommandSender)player, MessageKey.MAX_REGISTER_EXCEEDED, Integer.toString(maxRegPerIp), Integer.toString(otherAccounts.size()), StringUtils.join(", ", otherAccounts));
            return false;
        }
        return true;
    }

    public void register(Player player, String password, String email, boolean autoLogin) {
        if (this.preRegisterCheck(player, password)) {
            if (!StringUtils.isEmpty(email)) {
                this.emailRegister(player, password, email);
            } else {
                this.passwordRegister(player, password, autoLogin);
            }
        }
    }

    private void emailRegister(Player player, String password, String email) {
        int otherAccounts;
        String name = player.getName().toLowerCase();
        int maxRegPerEmail = this.service.getProperty(EmailSettings.MAX_REG_PER_EMAIL);
        if (maxRegPerEmail > 0 && !this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) && (otherAccounts = this.database.countAuthsByEmail(email)) >= maxRegPerEmail) {
            this.service.send((CommandSender)player, MessageKey.MAX_REGISTER_EXCEEDED, Integer.toString(maxRegPerEmail), Integer.toString(otherAccounts), "@");
            return;
        }
        HashedPassword hashedPassword = this.passwordSecurity.computeHash(password, name);
        String ip = Utils.getPlayerIp(player);
        PlayerAuth auth = PlayerAuth.builder().name(name).realName(player.getName()).password(hashedPassword).ip(ip).location(player.getLocation()).email(email).build();
        if (!this.database.saveAuth(auth)) {
            this.service.send((CommandSender)player, MessageKey.ERROR);
            return;
        }
        this.database.updateEmail(auth);
        this.database.updateSession(auth);
        this.sendMailSsl.sendPasswordMail(name, email, password);
        this.syncProcessManager.processSyncEmailRegister(player);
    }

    private void passwordRegister(Player player, String password, boolean autoLogin) {
        String name = player.getName().toLowerCase();
        String ip = Utils.getPlayerIp(player);
        HashedPassword hashedPassword = this.passwordSecurity.computeHash(password, name);
        PlayerAuth auth = PlayerAuth.builder().name(name).realName(player.getName()).password(hashedPassword).ip(ip).location(player.getLocation()).build();
        if (!this.database.saveAuth(auth)) {
            this.service.send((CommandSender)player, MessageKey.ERROR);
            return;
        }
        if (!this.service.getProperty(RegistrationSettings.FORCE_LOGIN_AFTER_REGISTER).booleanValue() && autoLogin) {
            if (this.service.getProperty(PluginSettings.USE_ASYNC_TASKS).booleanValue()) {
                this.bukkitService.runTaskAsynchronously(() -> this.asynchronousLogin.login(player, "dontneed", true));
            } else {
                this.bukkitService.scheduleSyncDelayedTask(() -> this.asynchronousLogin.login(player, "dontneed", true), 5L);
            }
        }
        this.syncProcessManager.processSyncPasswordRegister(player);
        if (this.service.getProperty(SecuritySettings.PASSWORD_HASH) == HashAlgorithm.TWO_FACTOR) {
            String qrCodeUrl = TwoFactor.getQRBarcodeURL(player.getName(), Bukkit.getIp(), hashedPassword.getHash());
            this.service.send((CommandSender)player, MessageKey.TWO_FACTOR_CREATE, hashedPassword.getHash(), qrCodeUrl);
        }
    }
}

