/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.quit;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.cache.SessionManager;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.CacheDataSource;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.Utils;
import fr.xephi.authme.util.ValidationService;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class AsynchronousQuit
implements AsynchronousProcess {
    @Inject
    private AuthMe plugin;
    @Inject
    private DataSource database;
    @Inject
    private ProcessService service;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private ValidationService validationService;

    AsynchronousQuit() {
    }

    public void processQuit(Player player) {
        if (player == null || this.validationService.isUnrestricted(player.getName())) {
            return;
        }
        String name = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(name)) {
            PlayerAuth auth;
            if (this.service.getProperty(RestrictionSettings.SAVE_QUIT_LOCATION).booleanValue()) {
                Location loc = this.spawnLoader.getPlayerLocationOrSpawn(player);
                auth = PlayerAuth.builder().name(name).location(loc).realName(player.getName()).build();
                this.database.updateQuitLoc(auth);
            }
            String ip = Utils.getPlayerIp(player);
            auth = PlayerAuth.builder().name(name).realName(player.getName()).ip(ip).lastLogin(System.currentTimeMillis()).build();
            this.database.updateSession(auth);
            this.sessionManager.addSession(name);
        }
        this.playerCache.removePlayer(name);
        this.database.setUnlogged(name);
        if (this.plugin.isEnabled()) {
            this.syncProcessManager.processSyncPlayerQuit(player);
        }
        if (this.database instanceof CacheDataSource) {
            ((CacheDataSource)this.database).getCachedAuths().invalidate((Object)name);
        }
    }
}

