/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.logout;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.SessionManager;
import fr.xephi.authme.events.LogoutEvent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.listener.protocollib.ProtocolLibService;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SynchronousProcess;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.TeleportationService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ProcessSynchronousPlayerLogout
implements SynchronousProcess {
    @Inject
    private ProcessService service;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private ProtocolLibService protocolLibService;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private TeleportationService teleportationService;

    ProcessSynchronousPlayerLogout() {
    }

    public void processSyncLogout(Player player) {
        String name = player.getName().toLowerCase();
        this.sessionManager.removeSession(name);
        if (this.service.getProperty(RestrictionSettings.PROTECT_INVENTORY_BEFORE_LOGIN).booleanValue()) {
            this.protocolLibService.sendBlankInventoryPacket(player);
        }
        this.playerDataTaskManager.registerTimeoutTask(player);
        this.playerDataTaskManager.registerMessageTask(name, true);
        this.applyLogoutEffect(player);
        this.bukkitService.callEvent(new LogoutEvent(player));
        this.service.send((CommandSender)player, MessageKey.LOGOUT_SUCCESS);
        ConsoleLogger.info(player.getName() + " logged out");
    }

    private void applyLogoutEffect(Player player) {
        player.leaveVehicle();
        this.teleportationService.teleportOnJoin(player);
        int timeout = this.service.getProperty(RestrictionSettings.TIMEOUT) * 20;
        if (this.service.getProperty(RegistrationSettings.APPLY_BLIND_EFFECT).booleanValue()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, timeout, 2));
        }
        this.service.setGroup(player, AuthGroupType.NOT_LOGGED_IN);
        player.setOp(false);
        player.setAllowFlight(false);
        if (!this.service.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT).booleanValue() && this.service.getProperty(RestrictionSettings.REMOVE_SPEED).booleanValue()) {
            player.setFlySpeed(0.0f);
            player.setWalkSpeed(0.0f);
        }
    }
}

