/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.logout;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsynchronousLogout
implements AsynchronousProcess {
    @Inject
    private DataSource database;
    @Inject
    private ProcessService service;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private LimboCache limboCache;
    @Inject
    private SyncProcessManager syncProcessManager;

    AsynchronousLogout() {
    }

    public void logout(Player player) {
        String name = player.getName().toLowerCase();
        if (!this.playerCache.isAuthenticated(name)) {
            this.service.send((CommandSender)player, MessageKey.NOT_LOGGED_IN);
            return;
        }
        PlayerAuth auth = this.playerCache.getAuth(name);
        this.database.updateSession(auth);
        if (this.service.getProperty(RestrictionSettings.SAVE_QUIT_LOCATION).booleanValue()) {
            auth.setQuitLocation(player.getLocation());
            this.database.updateQuitLoc(auth);
        }
        this.limboCache.addPlayerData(player);
        this.playerCache.removePlayer(name);
        this.database.setUnlogged(name);
        this.syncProcessManager.processSyncPlayerLogout(player);
    }
}

