/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.login;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.LoginEvent;
import fr.xephi.authme.events.RestoreInventoryEvent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.listener.PlayerListener;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SynchronousProcess;
import fr.xephi.authme.service.BungeeService;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.TeleportationService;
import org.apache.commons.lang.reflect.MethodUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;

public class ProcessSyncPlayerLogin
implements SynchronousProcess {
    private static final boolean RESTORE_COLLISIONS = MethodUtils.getAccessibleMethod(LivingEntity.class, (String)"setCollidable", (Class[])new Class[0]) != null;
    @Inject
    private AuthMe plugin;
    @Inject
    private BungeeService bungeeService;
    @Inject
    private ProcessService service;
    @Inject
    private LimboCache limboCache;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private TeleportationService teleportationService;
    @Inject
    private DataSource dataSource;

    ProcessSyncPlayerLogin() {
    }

    private void restoreInventory(Player player) {
        RestoreInventoryEvent event = new RestoreInventoryEvent(player);
        this.pluginManager.callEvent((Event)event);
        if (!event.isCancelled()) {
            player.updateInventory();
        }
    }

    private void forceCommands(Player player) {
        for (String command : this.service.getProperty(RegistrationSettings.FORCE_COMMANDS)) {
            player.performCommand(command.replace("%p", player.getName()));
        }
        for (String command : this.service.getProperty(RegistrationSettings.FORCE_COMMANDS_AS_CONSOLE)) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command.replace("%p", player.getName()));
        }
    }

    public void processPlayerLogin(Player player) {
        String name = player.getName().toLowerCase();
        PlayerData limbo = this.limboCache.getPlayerData(name);
        if (limbo != null) {
            this.limboCache.restoreData(player);
            this.limboCache.deletePlayerData(player);
        }
        if (RESTORE_COLLISIONS && !this.service.getProperty(PluginSettings.KEEP_COLLISIONS_DISABLED).booleanValue()) {
            player.setCollidable(true);
        }
        if (this.service.getProperty(RestrictionSettings.PROTECT_INVENTORY_BEFORE_LOGIN).booleanValue()) {
            this.restoreInventory(player);
        }
        PlayerAuth auth = this.dataSource.getAuth(name);
        this.teleportationService.teleportOnLogin(player, auth, limbo);
        String jm = PlayerListener.joinMessage.get(name);
        if (jm != null) {
            if (!jm.isEmpty()) {
                for (Player player2 : this.bukkitService.getOnlinePlayers()) {
                    if (!player2.isOnline()) continue;
                    player2.sendMessage(jm);
                }
            }
            PlayerListener.joinMessage.remove(name);
        }
        if (this.service.getProperty(RegistrationSettings.APPLY_BLIND_EFFECT).booleanValue()) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
        }
        this.bukkitService.callEvent(new LoginEvent(player));
        player.saveData();
        if (this.service.getProperty(RegistrationSettings.USE_WELCOME_MESSAGE).booleanValue()) {
            if (this.service.getProperty(RegistrationSettings.BROADCAST_WELCOME_MESSAGE).booleanValue()) {
                for (String s : this.service.getSettings().getWelcomeMessage()) {
                    Bukkit.getServer().broadcastMessage(this.plugin.replaceAllInfo(s, player));
                }
            } else {
                for (String s : this.service.getSettings().getWelcomeMessage()) {
                    player.sendMessage(this.plugin.replaceAllInfo(s, player));
                }
            }
        }
        this.forceCommands(player);
        this.bungeeService.connectPlayer(player);
    }
}

