/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.login;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.CaptchaManager;
import fr.xephi.authme.cache.TempbanManager;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.AuthMeAsyncPreLoginEvent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AdminPermission;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerPermission;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.SyncProcessManager;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsynchronousLogin
implements AsynchronousProcess {
    @Inject
    private DataSource database;
    @Inject
    private ProcessService service;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private LimboCache limboCache;
    @Inject
    private SyncProcessManager syncProcessManager;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private CaptchaManager captchaManager;
    @Inject
    private TempbanManager tempbanManager;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;

    AsynchronousLogin() {
    }

    private PlayerAuth preAuth(Player player) {
        String name = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(name)) {
            this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            return null;
        }
        PlayerAuth pAuth = this.database.getAuth(name);
        if (pAuth == null) {
            this.service.send((CommandSender)player, MessageKey.USER_NOT_REGISTERED);
            this.playerDataTaskManager.registerMessageTask(name, false);
            return null;
        }
        if (!this.service.getProperty(DatabaseSettings.MYSQL_COL_GROUP).isEmpty() && pAuth.getGroupId() == this.service.getProperty(HooksSettings.NON_ACTIVATED_USERS_GROUP).intValue()) {
            this.service.send((CommandSender)player, MessageKey.ACCOUNT_NOT_ACTIVATED);
            return null;
        }
        String ip = Utils.getPlayerIp(player);
        if (this.service.getProperty(RestrictionSettings.MAX_LOGIN_PER_IP) > 0 && !this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) && !"127.0.0.1".equalsIgnoreCase(ip) && !"localhost".equalsIgnoreCase(ip) && this.isLoggedIp(name, ip)) {
            this.service.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            return null;
        }
        boolean isAsync = this.service.getProperty(PluginSettings.USE_ASYNC_TASKS);
        AuthMeAsyncPreLoginEvent event = new AuthMeAsyncPreLoginEvent(player, isAsync);
        this.bukkitService.callEvent(event);
        if (!event.canLogin()) {
            return null;
        }
        return pAuth;
    }

    public void login(Player player, String password, boolean forceLogin) {
        boolean passwordVerified;
        PlayerAuth pAuth = this.preAuth(player);
        if (pAuth == null) {
            return;
        }
        String name = player.getName().toLowerCase();
        if (this.captchaManager.isCaptchaRequired(name)) {
            this.service.send((CommandSender)player, MessageKey.USAGE_CAPTCHA, this.captchaManager.getCaptchaCodeOrGenerateNew(name));
            return;
        }
        String ip = Utils.getPlayerIp(player);
        this.captchaManager.increaseCount(name);
        this.tempbanManager.increaseCount(ip, name);
        String email = pAuth.getEmail();
        boolean bl = passwordVerified = forceLogin || this.passwordSecurity.comparePassword(password, pAuth.getPassword(), player.getName());
        if (passwordVerified && player.isOnline()) {
            PlayerAuth auth = PlayerAuth.builder().name(name).realName(player.getName()).ip(ip).email(email).password(pAuth.getPassword()).build();
            this.database.updateSession(auth);
            this.captchaManager.resetCounts(name);
            this.tempbanManager.resetCount(ip, name);
            player.setNoDamageTicks(0);
            if (!forceLogin) {
                this.service.send((CommandSender)player, MessageKey.LOGIN_SUCCESS);
            }
            this.displayOtherAccounts(auth, player);
            if (this.service.getProperty(EmailSettings.RECALL_PLAYERS).booleanValue() && (StringUtils.isEmpty(email) || "your@email.com".equalsIgnoreCase(email))) {
                this.service.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
            }
            ConsoleLogger.fine(player.getName() + " logged in!");
            this.playerCache.addPlayer(auth);
            this.database.setLogged(name);
            PlayerData playerData = this.limboCache.getPlayerData(name);
            if (playerData != null) {
                playerData.clearTasks();
            }
            this.syncProcessManager.processSyncPlayerLogin(player);
        } else if (player.isOnline()) {
            ConsoleLogger.fine(player.getName() + " used the wrong password");
            if (this.service.getProperty(RestrictionSettings.KICK_ON_WRONG_PASSWORD).booleanValue()) {
                this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(() -> player.kickPlayer(this.service.retrieveSingleMessage(MessageKey.WRONG_PASSWORD)));
            } else if (this.tempbanManager.shouldTempban(ip)) {
                this.tempbanManager.tempbanPlayer(player);
            } else {
                this.service.send((CommandSender)player, MessageKey.WRONG_PASSWORD);
                if (this.captchaManager.isCaptchaRequired(name)) {
                    this.service.send((CommandSender)player, MessageKey.USAGE_CAPTCHA, this.captchaManager.getCaptchaCodeOrGenerateNew(name));
                }
            }
        } else {
            ConsoleLogger.warning("Player " + name + " wasn't online during login process, aborted... ");
        }
    }

    private void displayOtherAccounts(PlayerAuth auth, Player player) {
        if (!this.service.getProperty(RestrictionSettings.DISPLAY_OTHER_ACCOUNTS).booleanValue() || auth == null) {
            return;
        }
        List<String> auths = this.database.getAllAuthsByIp(auth.getIp());
        if (auths.size() <= 1) {
            return;
        }
        ArrayList<String> formattedNames = new ArrayList<String>(auths.size());
        for (String currentName : auths) {
            Player player2 = this.bukkitService.getPlayerExact(currentName);
            if (player2 != null && player2.isOnline()) {
                formattedNames.add(ChatColor.GREEN + currentName);
                continue;
            }
            formattedNames.add(currentName);
        }
        String message = ChatColor.GRAY + StringUtils.join(ChatColor.GRAY + ", ", formattedNames) + ".";
        ConsoleLogger.fine("The user " + player.getName() + " has " + auths.size() + " accounts:");
        ConsoleLogger.fine(message);
        for (Player player3 : this.bukkitService.getOnlinePlayers()) {
            if (player3.getName().equalsIgnoreCase(player.getName()) && this.permissionsManager.hasPermission((CommandSender)player3, PlayerPermission.SEE_OWN_ACCOUNTS)) {
                this.service.send((CommandSender)player3, MessageKey.ACCOUNTS_OWNED_SELF, Integer.toString(auths.size()));
                player3.sendMessage(message);
                continue;
            }
            if (!this.permissionsManager.hasPermission((CommandSender)player3, AdminPermission.SEE_OTHER_ACCOUNTS)) continue;
            this.service.send((CommandSender)player3, MessageKey.ACCOUNTS_OWNED_OTHER, player.getName(), Integer.toString(auths.size()));
            player3.sendMessage(message);
        }
    }

    private boolean isLoggedIp(String name, String ip) {
        int count = 0;
        for (Player player : this.bukkitService.getOnlinePlayers()) {
            if (!ip.equalsIgnoreCase(Utils.getPlayerIp(player)) || !this.database.isLogged(player.getName().toLowerCase()) || player.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count >= this.service.getProperty(RestrictionSettings.MAX_LOGIN_PER_IP);
    }
}

