/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.join;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.SessionManager;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.events.ProtectInventoryEvent;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.process.login.AsynchronousLogin;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.PlayerDataTaskManager;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.Utils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class AsynchronousJoin
implements AsynchronousProcess {
    private static final boolean DISABLE_COLLISIONS = MethodUtils.getAccessibleMethod(LivingEntity.class, (String)"setCollidable", (Class[])new Class[0]) != null;
    @Inject
    private AuthMe plugin;
    @Inject
    private DataSource database;
    @Inject
    private ProcessService service;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private LimboCache limboCache;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private PluginHooks pluginHooks;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PlayerDataTaskManager playerDataTaskManager;
    @Inject
    private AsynchronousLogin asynchronousLogin;

    AsynchronousJoin() {
    }

    public void processJoin(final Player player) {
        String name = player.getName().toLowerCase();
        final String ip = Utils.getPlayerIp(player);
        if (this.isPlayerUnrestricted(name)) {
            return;
        }
        if (DISABLE_COLLISIONS) {
            player.setCollidable(false);
        }
        if (this.service.getProperty(RestrictionSettings.FORCE_SURVIVAL_MODE).booleanValue() && !this.service.hasPermission(player, PlayerStatePermission.BYPASS_FORCE_SURVIVAL)) {
            this.bukkitService.runTask(() -> player.setGameMode(GameMode.SURVIVAL));
        }
        if (this.service.getProperty(HooksSettings.DISABLE_SOCIAL_SPY).booleanValue()) {
            this.pluginHooks.setEssentialsSocialSpyStatus(player, false);
        }
        if (this.isNameRestricted(name, ip, player.getAddress().getHostName())) {
            this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer(AsynchronousJoin.this.service.retrieveSingleMessage(MessageKey.NOT_OWNER_ERROR));
                    if (AsynchronousJoin.this.service.getProperty(RestrictionSettings.BAN_UNKNOWN_IP).booleanValue()) {
                        AsynchronousJoin.this.plugin.getServer().banIP(ip);
                    }
                }
            });
            return;
        }
        if (!this.validatePlayerCountForIp(player, ip)) {
            return;
        }
        boolean isAuthAvailable = this.database.isAuthAvailable(name);
        if (isAuthAvailable) {
            this.limboCache.addPlayerData(player);
            this.service.setGroup(player, AuthGroupType.NOT_LOGGED_IN);
            if (this.service.getProperty(RestrictionSettings.PROTECT_INVENTORY_BEFORE_LOGIN).booleanValue()) {
                boolean isAsync = this.service.getProperty(PluginSettings.USE_ASYNC_TASKS);
                ProtectInventoryEvent ev = new ProtectInventoryEvent(player, isAsync);
                this.bukkitService.callEvent(ev);
                if (ev.isCancelled()) {
                    player.updateInventory();
                    ConsoleLogger.fine("ProtectInventoryEvent has been cancelled for " + player.getName() + "...");
                }
            }
            if (this.sessionManager.hasSession(name) || this.database.isLogged(name)) {
                PlayerAuth auth = this.database.getAuth(name);
                this.database.setUnlogged(name);
                this.playerCache.removePlayer(name);
                if (auth != null && auth.getIp().equals(ip)) {
                    this.service.send((CommandSender)player, MessageKey.SESSION_RECONNECTION);
                    this.bukkitService.runTaskOptionallyAsync(() -> this.asynchronousLogin.login(player, "dontneed", true));
                    return;
                }
                if (this.service.getProperty(PluginSettings.SESSIONS_EXPIRE_ON_IP_CHANGE).booleanValue()) {
                    this.service.send((CommandSender)player, MessageKey.SESSION_EXPIRED);
                }
            }
        } else {
            this.limboCache.deletePlayerData(player);
            this.limboCache.addPlayerData(player);
            this.service.setGroup(player, AuthGroupType.UNREGISTERED);
            if (!this.service.getProperty(RegistrationSettings.FORCE).booleanValue()) {
                return;
            }
        }
        final int registrationTimeout = this.service.getProperty(RestrictionSettings.TIMEOUT) * 20;
        this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(new Runnable(){

            @Override
            public void run() {
                player.setOp(false);
                if (!AsynchronousJoin.this.service.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT).booleanValue() && AsynchronousJoin.this.service.getProperty(RestrictionSettings.REMOVE_SPEED).booleanValue()) {
                    player.setFlySpeed(0.0f);
                    player.setWalkSpeed(0.0f);
                }
                player.setNoDamageTicks(registrationTimeout);
                if (AsynchronousJoin.this.pluginHooks.isEssentialsAvailable() && AsynchronousJoin.this.service.getProperty(HooksSettings.USE_ESSENTIALS_MOTD).booleanValue()) {
                    player.performCommand("motd");
                }
                if (AsynchronousJoin.this.service.getProperty(RegistrationSettings.APPLY_BLIND_EFFECT).booleanValue()) {
                    int blindTimeOut = registrationTimeout <= 0 ? 99999 : registrationTimeout;
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, blindTimeOut, 2));
                }
            }
        });
        this.playerDataTaskManager.registerTimeoutTask(player);
        this.playerDataTaskManager.registerMessageTask(name, isAuthAvailable);
    }

    private boolean isPlayerUnrestricted(String name) {
        return this.service.getProperty(RestrictionSettings.UNRESTRICTED_NAMES).contains(name);
    }

    private boolean isNameRestricted(String name, String ip, String domain) {
        if (!this.service.getProperty(RestrictionSettings.ENABLE_RESTRICTED_USERS).booleanValue()) {
            return false;
        }
        boolean nameFound = false;
        for (String entry : this.service.getProperty(RestrictionSettings.ALLOWED_RESTRICTED_USERS)) {
            String[] args = entry.split(";");
            String testName = args[0];
            String testIp = args[1];
            if (!testName.equalsIgnoreCase(name)) continue;
            nameFound = true;
            if ((ip == null || !testIp.equals(ip)) && (domain == null || !testIp.equalsIgnoreCase(domain))) continue;
            return false;
        }
        return nameFound;
    }

    private boolean validatePlayerCountForIp(final Player player, String ip) {
        if (!(this.service.getProperty(RestrictionSettings.MAX_JOIN_PER_IP) <= 0 || this.service.hasPermission(player, PlayerStatePermission.ALLOW_MULTIPLE_ACCOUNTS) || "127.0.0.1".equalsIgnoreCase(ip) || "localhost".equalsIgnoreCase(ip) || this.countOnlinePlayersByIp(ip) <= this.service.getProperty(RestrictionSettings.MAX_JOIN_PER_IP))) {
            this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer(AsynchronousJoin.this.service.retrieveSingleMessage(MessageKey.SAME_IP_ONLINE));
                }
            });
            return false;
        }
        return true;
    }

    private int countOnlinePlayersByIp(String ip) {
        int count = 0;
        for (Player player : this.bukkitService.getOnlinePlayers()) {
            if (!ip.equalsIgnoreCase(Utils.getPlayerIp(player))) continue;
            ++count;
        }
        return count;
    }
}

