/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.email;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsyncChangeEmail
implements AsynchronousProcess {
    @Inject
    private ProcessService service;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private DataSource dataSource;

    AsyncChangeEmail() {
    }

    public void changeEmail(Player player, String oldEmail, String newEmail) {
        String playerName = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(playerName)) {
            PlayerAuth auth = this.playerCache.getAuth(playerName);
            String currentEmail = auth.getEmail();
            if (currentEmail == null) {
                this.service.send((CommandSender)player, MessageKey.USAGE_ADD_EMAIL);
            } else if (newEmail == null || !this.service.validateEmail(newEmail)) {
                this.service.send((CommandSender)player, MessageKey.INVALID_NEW_EMAIL);
            } else if (!oldEmail.equals(currentEmail)) {
                this.service.send((CommandSender)player, MessageKey.INVALID_OLD_EMAIL);
            } else if (!this.service.isEmailFreeForRegistration(newEmail, (CommandSender)player)) {
                this.service.send((CommandSender)player, MessageKey.EMAIL_ALREADY_USED_ERROR);
            } else {
                this.saveNewEmail(auth, player, newEmail);
            }
        } else {
            this.outputUnloggedMessage(player);
        }
    }

    private void saveNewEmail(PlayerAuth auth, Player player, String newEmail) {
        auth.setEmail(newEmail);
        if (this.dataSource.updateEmail(auth)) {
            this.playerCache.updatePlayer(auth);
            this.service.send((CommandSender)player, MessageKey.EMAIL_CHANGED_SUCCESS);
        } else {
            this.service.send((CommandSender)player, MessageKey.ERROR);
        }
    }

    private void outputUnloggedMessage(Player player) {
        if (this.dataSource.isAuthAvailable(player.getName())) {
            this.service.send((CommandSender)player, MessageKey.LOGIN_MESSAGE);
        } else if (this.service.getProperty(RegistrationSettings.USE_EMAIL_REGISTRATION).booleanValue()) {
            this.service.send((CommandSender)player, MessageKey.REGISTER_EMAIL_MESSAGE);
        } else {
            this.service.send((CommandSender)player, MessageKey.REGISTER_MESSAGE);
        }
    }
}

