/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.email;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsyncAddEmail
implements AsynchronousProcess {
    @Inject
    private ProcessService service;
    @Inject
    private DataSource dataSource;
    @Inject
    private PlayerCache playerCache;

    AsyncAddEmail() {
    }

    public void addEmail(Player player, String email) {
        String playerName = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(playerName)) {
            PlayerAuth auth = this.playerCache.getAuth(playerName);
            String currentEmail = auth.getEmail();
            if (currentEmail != null && !"your@email.com".equals(currentEmail)) {
                this.service.send((CommandSender)player, MessageKey.USAGE_CHANGE_EMAIL);
            } else if (!this.service.validateEmail(email)) {
                this.service.send((CommandSender)player, MessageKey.INVALID_EMAIL);
            } else if (!this.service.isEmailFreeForRegistration(email, (CommandSender)player)) {
                this.service.send((CommandSender)player, MessageKey.EMAIL_ALREADY_USED_ERROR);
            } else {
                auth.setEmail(email);
                if (this.dataSource.updateEmail(auth)) {
                    this.playerCache.updatePlayer(auth);
                    this.service.send((CommandSender)player, MessageKey.EMAIL_ADDED_SUCCESS);
                } else {
                    ConsoleLogger.warning("Could not save email for player '" + player + "'");
                    this.service.send((CommandSender)player, MessageKey.ERROR);
                }
            }
        } else {
            this.sendUnloggedMessage(player);
        }
    }

    private void sendUnloggedMessage(Player player) {
        if (this.dataSource.isAuthAvailable(player.getName())) {
            this.service.send((CommandSender)player, MessageKey.LOGIN_MESSAGE);
        } else if (this.service.getProperty(RegistrationSettings.USE_EMAIL_REGISTRATION).booleanValue()) {
            this.service.send((CommandSender)player, MessageKey.REGISTER_EMAIL_MESSAGE);
        } else {
            this.service.send((CommandSender)player, MessageKey.REGISTER_MESSAGE);
        }
    }
}

