/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process.changepassword;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.AsynchronousProcess;
import fr.xephi.authme.process.ProcessService;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AsyncChangePassword
implements AsynchronousProcess {
    @Inject
    private DataSource dataSource;
    @Inject
    private ProcessService processService;
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private PlayerCache playerCache;

    AsyncChangePassword() {
    }

    public void changePassword(Player player, String oldPassword, String newPassword) {
        String name = player.getName().toLowerCase();
        PlayerAuth auth = this.playerCache.getAuth(name);
        if (this.passwordSecurity.comparePassword(oldPassword, auth.getPassword(), player.getName())) {
            HashedPassword hashedPassword = this.passwordSecurity.computeHash(newPassword, name);
            auth.setPassword(hashedPassword);
            if (!this.dataSource.updatePassword(auth)) {
                this.processService.send((CommandSender)player, MessageKey.ERROR);
                return;
            }
            this.playerCache.updatePlayer(auth);
            this.processService.send((CommandSender)player, MessageKey.PASSWORD_CHANGED_SUCCESS);
            ConsoleLogger.info(player.getName() + " changed his password");
        } else {
            this.processService.send((CommandSender)player, MessageKey.WRONG_PASSWORD);
        }
    }
}

