/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process;

import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.process.login.ProcessSyncPlayerLogin;
import fr.xephi.authme.process.logout.ProcessSynchronousPlayerLogout;
import fr.xephi.authme.process.quit.ProcessSyncronousPlayerQuit;
import fr.xephi.authme.process.register.ProcessSyncEmailRegister;
import fr.xephi.authme.process.register.ProcessSyncPasswordRegister;
import fr.xephi.authme.util.BukkitService;
import org.bukkit.entity.Player;

public class SyncProcessManager {
    @Inject
    private BukkitService bukkitService;
    @Inject
    private ProcessSyncEmailRegister processSyncEmailRegister;
    @Inject
    private ProcessSyncPasswordRegister processSyncPasswordRegister;
    @Inject
    private ProcessSyncPlayerLogin processSyncPlayerLogin;
    @Inject
    private ProcessSynchronousPlayerLogout processSynchronousPlayerLogout;
    @Inject
    private ProcessSyncronousPlayerQuit processSyncronousPlayerQuit;

    public void processSyncEmailRegister(Player player) {
        this.runTask(() -> this.processSyncEmailRegister.processEmailRegister(player));
    }

    public void processSyncPasswordRegister(Player player) {
        this.runTask(() -> this.processSyncPasswordRegister.processPasswordRegister(player));
    }

    public void processSyncPlayerLogout(Player player) {
        this.runTask(() -> this.processSynchronousPlayerLogout.processSyncLogout(player));
    }

    public void processSyncPlayerLogin(Player player) {
        this.runTask(() -> this.processSyncPlayerLogin.processPlayerLogin(player));
    }

    public void processSyncPlayerQuit(Player player) {
        this.runTask(() -> this.processSyncronousPlayerQuit.processSyncQuit(player));
    }

    private void runTask(Runnable runnable) {
        this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(runnable);
    }
}

