/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.process;

import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.permission.AuthGroupHandler;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.util.ValidationService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProcessService {
    @Inject
    private Settings settings;
    @Inject
    private Messages messages;
    @Inject
    private ValidationService validationService;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private AuthGroupHandler authGroupHandler;

    public <T> T getProperty(Property<T> property) {
        return this.settings.getProperty(property);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void send(CommandSender sender, MessageKey key) {
        this.messages.send(sender, key);
    }

    public void send(CommandSender sender, MessageKey key, String ... replacements) {
        this.messages.send(sender, key, replacements);
    }

    public String[] retrieveMessage(MessageKey key) {
        return this.messages.retrieve(key);
    }

    public String retrieveSingleMessage(MessageKey key) {
        return this.messages.retrieveSingle(key, new String[0]);
    }

    public boolean validateEmail(String email) {
        return this.validationService.validateEmail(email);
    }

    public boolean isEmailFreeForRegistration(String email, CommandSender sender) {
        return this.validationService.isEmailFreeForRegistration(email, sender);
    }

    public boolean hasPermission(Player player, PermissionNode node) {
        return this.permissionsManager.hasPermission((CommandSender)player, node);
    }

    public boolean setGroup(Player player, AuthGroupType group) {
        return this.authGroupHandler.setGroup(player, group);
    }
}

