/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.tyrannyofheaven.bukkit.zPermissions.ZPermissionsService;

public class ZPermissionsHandler
implements PermissionHandler {
    private ZPermissionsService zPermissionsService;

    public ZPermissionsHandler() throws PermissionHandlerException {
        ZPermissionsService zPermissionsService = (ZPermissionsService)Bukkit.getServicesManager().load(ZPermissionsService.class);
        if (zPermissionsService == null) {
            throw new PermissionHandlerException("Failed to get the ZPermissions service!");
        }
        this.zPermissionsService = zPermissionsService;
    }

    @Override
    public boolean addToGroup(Player player, String group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " addgroup " + group));
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        Map perms = this.zPermissionsService.getPlayerPermissions(null, null, name);
        if (perms.containsKey(node.getNode())) {
            return (Boolean)perms.get(node.getNode());
        }
        return false;
    }

    @Override
    public boolean isInGroup(Player player, String group) {
        return this.getGroups(player).contains(group);
    }

    @Override
    public boolean removeFromGroup(Player player, String group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " removegroup " + group));
    }

    @Override
    public boolean setGroup(Player player, String group) {
        return Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("permissions player " + player.getName() + " setgroup " + group));
    }

    @Override
    public List<String> getGroups(Player player) {
        return new ArrayList<String>(this.zPermissionsService.getPlayerGroups(player.getName()));
    }

    @Override
    public String getPrimaryGroup(Player player) {
        return this.zPermissionsService.getPlayerPrimaryGroup(player.getName());
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.Z_PERMISSIONS;
    }
}

