/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.Arrays;
import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHandler
implements PermissionHandler {
    private Permission vaultProvider;

    public VaultHandler(Server server) throws PermissionHandlerException {
        this.vaultProvider = VaultHandler.getVaultPermission(server);
    }

    private static Permission getVaultPermission(Server server) throws PermissionHandlerException {
        RegisteredServiceProvider permissionProvider = server.getServicesManager().getRegistration(Permission.class);
        if (permissionProvider == null) {
            throw new PermissionHandlerException("Could not load permissions provider service");
        }
        Permission vaultPerms = (Permission)permissionProvider.getProvider();
        if (vaultPerms == null) {
            throw new PermissionHandlerException("Could not load Vault permissions provider");
        }
        return vaultPerms;
    }

    @Override
    public boolean addToGroup(Player player, String group) {
        return this.vaultProvider.playerAddGroup(player, group);
    }

    @Override
    public boolean hasGroupSupport() {
        return this.vaultProvider.hasGroupSupport();
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        return this.vaultProvider.has("", name, node.getNode());
    }

    @Override
    public boolean isInGroup(Player player, String group) {
        return this.vaultProvider.playerInGroup(player, group);
    }

    @Override
    public boolean removeFromGroup(Player player, String group) {
        return this.vaultProvider.playerRemoveGroup(player, group);
    }

    @Override
    public boolean setGroup(Player player, String group) {
        for (String groupName : this.getGroups(player)) {
            this.removeFromGroup(player, groupName);
        }
        return this.vaultProvider.playerAddGroup(player, group);
    }

    @Override
    public List<String> getGroups(Player player) {
        return Arrays.asList(this.vaultProvider.getPlayerGroups(player));
    }

    @Override
    public String getPrimaryGroup(Player player) {
        return this.vaultProvider.getPrimaryGroup(player);
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.VAULT;
    }
}

