/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission.handlers;

import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PermissionsExHandler
implements PermissionHandler {
    private PermissionManager permissionManager = PermissionsEx.getPermissionManager();

    public PermissionsExHandler() throws PermissionHandlerException {
        if (this.permissionManager == null) {
            throw new PermissionHandlerException("Could not get manager of PermissionsEx");
        }
    }

    @Override
    public boolean addToGroup(Player player, String group) {
        if (!PermissionsEx.getPermissionManager().getGroupNames().contains(group)) {
            return false;
        }
        PermissionUser user = PermissionsEx.getUser((Player)player);
        user.addGroup(group);
        return true;
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    @Override
    public boolean hasPermissionOffline(String name, PermissionNode node) {
        PermissionUser user = this.permissionManager.getUser(name);
        return user.has(node.getNode());
    }

    @Override
    public boolean isInGroup(Player player, String group) {
        PermissionUser user = this.permissionManager.getUser(player);
        return user.inGroup(group);
    }

    @Override
    public boolean removeFromGroup(Player player, String group) {
        PermissionUser user = this.permissionManager.getUser(player);
        user.removeGroup(group);
        return true;
    }

    @Override
    public boolean setGroup(Player player, String group) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(group);
        PermissionUser user = this.permissionManager.getUser(player);
        user.setParentsIdentifier(groups);
        return true;
    }

    @Override
    public List<String> getGroups(Player player) {
        PermissionUser user = this.permissionManager.getUser(player);
        return user.getParentIdentifiers(null);
    }

    @Override
    public String getPrimaryGroup(Player player) {
        PermissionUser user = this.permissionManager.getUser(player);
        List groups = user.getParentIdentifiers(null);
        if (groups.size() == 0) {
            return null;
        }
        return (String)groups.get(0);
    }

    @Override
    public PermissionsSystemType getPermissionSystem() {
        return PermissionsSystemType.PERMISSIONS_EX;
    }
}

