/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsSystemType;
import fr.xephi.authme.permission.handlers.BPermissionsHandler;
import fr.xephi.authme.permission.handlers.PermissionHandler;
import fr.xephi.authme.permission.handlers.PermissionHandlerException;
import fr.xephi.authme.permission.handlers.PermissionsBukkitHandler;
import fr.xephi.authme.permission.handlers.PermissionsExHandler;
import fr.xephi.authme.permission.handlers.VaultHandler;
import fr.xephi.authme.permission.handlers.ZPermissionsHandler;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PermissionsManager
implements Reloadable {
    private final Server server;
    private final PluginManager pluginManager;
    private PermissionHandler handler = null;

    @Inject
    public PermissionsManager(Server server, PluginManager pluginManager) {
        this.server = server;
        this.pluginManager = pluginManager;
    }

    public boolean isEnabled() {
        return this.handler != null;
    }

    @PostConstruct
    private void setup() {
        for (PermissionsSystemType type : PermissionsSystemType.values()) {
            try {
                PermissionHandler handler = this.getPermissionHandler(type);
                if (handler == null) continue;
                this.handler = handler;
                ConsoleLogger.info("Hooked into " + type.getName() + "!");
                return;
            }
            catch (Exception ex) {
                ConsoleLogger.logException("Error while hooking into " + type.getName(), ex);
            }
        }
        ConsoleLogger.info("No supported permissions system found! Permissions are disabled!");
    }

    private PermissionHandler getPermissionHandler(PermissionsSystemType type) throws PermissionHandlerException {
        Plugin plugin = this.pluginManager.getPlugin(type.getPluginName());
        if (plugin == null) {
            return null;
        }
        if (!plugin.isEnabled()) {
            ConsoleLogger.info("Not hooking into " + type.getName() + " because it's disabled!");
            return null;
        }
        switch (type) {
            case PERMISSIONS_EX: {
                return new PermissionsExHandler();
            }
            case Z_PERMISSIONS: {
                return new ZPermissionsHandler();
            }
            case VAULT: {
                return new VaultHandler(this.server);
            }
            case B_PERMISSIONS: {
                return new BPermissionsHandler();
            }
            case PERMISSIONS_BUKKIT: {
                return new PermissionsBukkitHandler();
            }
        }
        throw new IllegalStateException("Unhandled permission type '" + (Object)((Object)type) + "'");
    }

    private void unhook() {
        this.handler = null;
        ConsoleLogger.info("Unhooked from Permissions!");
    }

    @Override
    public void reload() {
        this.unhook();
        this.setup();
    }

    public void onPluginEnable(String pluginName) {
        if (PermissionsSystemType.isPermissionSystem(pluginName)) {
            ConsoleLogger.info(pluginName + " plugin enabled, dynamically updating permissions hooks!");
            this.setup();
        }
    }

    public void onPluginDisable(String pluginName) {
        if (PermissionsSystemType.isPermissionSystem(pluginName)) {
            ConsoleLogger.info(pluginName + " plugin disabled, updating hooks!");
            this.setup();
        }
    }

    public PermissionsSystemType getPermissionSystem() {
        return this.isEnabled() ? this.handler.getPermissionSystem() : null;
    }

    public boolean hasPermission(CommandSender sender, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!(sender instanceof Player) || !this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate((ServerOperator)sender);
        }
        Player player = (Player)sender;
        return player.hasPermission(permissionNode.getNode());
    }

    public boolean hasPermissionOffline(OfflinePlayer player, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate((ServerOperator)player);
        }
        return this.handler.hasPermissionOffline(player.getName(), permissionNode);
    }

    public boolean hasPermissionOffline(String name, PermissionNode permissionNode) {
        if (permissionNode == null) {
            return true;
        }
        if (!this.isEnabled()) {
            return permissionNode.getDefaultPermission().evaluate(null);
        }
        return this.handler.hasPermissionOffline(name, permissionNode);
    }

    public boolean hasGroupSupport() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.handler.hasGroupSupport();
    }

    public List<String> getGroups(Player player) {
        if (!this.isEnabled()) {
            return new ArrayList<String>();
        }
        return this.handler.getGroups(player);
    }

    public String getPrimaryGroup(Player player) {
        if (!this.isEnabled()) {
            return null;
        }
        return this.handler.getPrimaryGroup(player);
    }

    public boolean inGroup(Player player, String groupName) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.handler.isInGroup(player, groupName);
    }

    public boolean addGroup(Player player, String groupName) {
        if (StringUtils.isEmpty(groupName)) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        return this.handler.addToGroup(player, groupName);
    }

    public boolean addGroups(Player player, List<String> groupNames) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = true;
        for (String groupName : groupNames) {
            if (this.addGroup(player, groupName)) continue;
            result = false;
        }
        return result;
    }

    public boolean removeGroup(Player player, String groupName) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.handler.removeFromGroup(player, groupName);
    }

    public boolean removeGroups(Player player, List<String> groupNames) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean result = true;
        for (String groupName : groupNames) {
            if (this.removeGroup(player, groupName)) continue;
            result = false;
        }
        return result;
    }

    public boolean setGroup(Player player, String groupName) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.handler.setGroup(player, groupName);
    }

    public boolean setGroups(Player player, List<String> groupNames) {
        if (!this.isEnabled() || groupNames.size() <= 0) {
            return false;
        }
        if (!this.setGroup(player, groupNames.get(0))) {
            return false;
        }
        boolean result = true;
        for (int i = 1; i < groupNames.size(); ++i) {
            String groupName = groupNames.get(i);
            if (this.addGroup(player, groupName)) continue;
            result = false;
        }
        return result;
    }

    public boolean removeAllGroups(Player player) {
        if (!this.isEnabled()) {
            return false;
        }
        List<String> groupNames = this.getGroups(player);
        return this.removeGroups(player, groupNames);
    }
}

