/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.permission;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.cache.limbo.PlayerData;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.AuthGroupType;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.Arrays;
import org.bukkit.entity.Player;

public class AuthGroupHandler
implements Reloadable {
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private Settings settings;
    @Inject
    private LimboCache limboCache;
    private String unloggedInGroup;
    private String unregisteredGroup;
    private String registeredGroup;

    AuthGroupHandler() {
    }

    public boolean setGroup(Player player, AuthGroupType group) {
        if (!this.settings.getProperty(PluginSettings.ENABLE_PERMISSION_CHECK).booleanValue()) {
            return false;
        }
        if (!this.permissionsManager.hasGroupSupport()) {
            ConsoleLogger.warning("The current permissions system doesn't have group support, unable to set group!");
            return false;
        }
        switch (group) {
            case UNREGISTERED: {
                this.permissionsManager.removeGroups(player, Arrays.asList(this.registeredGroup, this.unloggedInGroup));
                return this.permissionsManager.addGroup(player, this.unregisteredGroup);
            }
            case REGISTERED: {
                this.permissionsManager.removeGroups(player, Arrays.asList(this.unregisteredGroup, this.unloggedInGroup));
                return this.permissionsManager.addGroup(player, this.registeredGroup);
            }
            case NOT_LOGGED_IN: {
                this.permissionsManager.removeGroups(player, Arrays.asList(this.unregisteredGroup, this.registeredGroup));
                return this.permissionsManager.addGroup(player, this.unloggedInGroup);
            }
            case LOGGED_IN: {
                PlayerData data = this.limboCache.getPlayerData(player.getName().toLowerCase());
                if (data == null) {
                    return false;
                }
                String realGroup = data.getGroup();
                this.permissionsManager.removeGroups(player, Arrays.asList(this.unregisteredGroup, this.registeredGroup, this.unloggedInGroup));
                return this.permissionsManager.addGroup(player, realGroup);
            }
        }
        return false;
    }

    public boolean addNormal(Player player, String group) {
        if (!this.settings.getProperty(PluginSettings.ENABLE_PERMISSION_CHECK).booleanValue()) {
            return false;
        }
        this.permissionsManager.removeGroups(player, Arrays.asList(this.unregisteredGroup, this.registeredGroup, this.unloggedInGroup));
        return this.permissionsManager.addGroup(player, group);
    }

    @Override
    public void reload() {
        this.unloggedInGroup = this.settings.getProperty(SecuritySettings.UNLOGGEDIN_GROUP);
        this.unregisteredGroup = this.settings.getProperty(HooksSettings.UNREGISTERED_GROUP);
        this.registeredGroup = this.settings.getProperty(HooksSettings.REGISTERED_GROUP);
    }
}

