/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.output;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.settings.Settings;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Messages
implements SettingsDependent {
    private static final String NEWLINE_TAG = "%nl%";
    private FileConfiguration configuration;
    private String fileName;
    private final String defaultFile;
    private FileConfiguration defaultConfiguration;

    @Inject
    Messages(Settings settings) {
        this.reload(settings);
        this.defaultFile = settings.getDefaultMessagesFile();
    }

    public void send(CommandSender sender, MessageKey key) {
        String[] lines;
        for (String line : lines = this.retrieve(key)) {
            sender.sendMessage(line);
        }
    }

    public void send(CommandSender sender, MessageKey key, String ... replacements) {
        String message = this.retrieveSingle(key, replacements);
        for (String line : message.split("\n")) {
            sender.sendMessage(line);
        }
    }

    public String[] retrieve(MessageKey key) {
        String message = this.retrieveMessage(key);
        if (message.isEmpty()) {
            return new String[0];
        }
        return message.split("\n");
    }

    private String retrieveMessage(MessageKey key) {
        String code = key.getKey();
        String message = this.configuration.getString(code);
        if (message == null) {
            ConsoleLogger.warning("Error getting message with key '" + code + "'. Please verify your config file at '" + this.fileName + "'");
            return Messages.formatMessage(this.getDefault(code));
        }
        return Messages.formatMessage(message);
    }

    public String retrieveSingle(MessageKey key, String ... replacements) {
        String message = this.retrieveMessage(key);
        String[] tags = key.getTags();
        if (replacements.length == tags.length) {
            for (int i = 0; i < tags.length; ++i) {
                message = message.replace(tags[i], replacements[i]);
            }
        } else {
            ConsoleLogger.warning("Invalid number of replacements for message key '" + (Object)((Object)key) + "'");
        }
        return message;
    }

    @Override
    public void reload(Settings settings) {
        File messageFile = settings.getMessagesFile();
        this.configuration = YamlConfiguration.loadConfiguration((File)messageFile);
        this.fileName = messageFile.getName();
    }

    private String getDefault(String code) {
        String message;
        if (this.defaultFile == null) {
            return Messages.getDefaultErrorMessage(code);
        }
        if (this.defaultConfiguration == null) {
            InputStream stream = Messages.class.getResourceAsStream(this.defaultFile);
            this.defaultConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
        }
        return (message = this.defaultConfiguration.getString(code)) == null ? Messages.getDefaultErrorMessage(code) : message;
    }

    private static String getDefaultErrorMessage(String code) {
        return "Error retrieving message '" + code + "'";
    }

    private static String formatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message).replace(NEWLINE_TAG, "\n");
    }
}

