/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.mail;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.mail.ImageGenerator;
import fr.xephi.authme.mail.OAuth2Provider;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.StringUtils;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.Properties;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import javax.mail.Session;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class SendMailSSL {
    @Inject
    private AuthMe plugin;
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;

    SendMailSSL() {
    }

    public boolean hasAllInformation() {
        return !this.settings.getProperty(EmailSettings.MAIL_ACCOUNT).isEmpty() && !this.settings.getProperty(EmailSettings.MAIL_PASSWORD).isEmpty();
    }

    public void sendPasswordMail(final String name, final String mailAddress, final String newPass) {
        if (!this.hasAllInformation()) {
            ConsoleLogger.warning("Cannot perform email registration: not all email settings are complete");
            return;
        }
        final String mailText = this.replaceTagsForPasswordMail(this.settings.getPasswordEmailMessage(), name, newPass);
        this.bukkitService.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                HtmlEmail email;
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    email = SendMailSSL.this.initializeMail(mailAddress);
                }
                catch (EmailException e) {
                    ConsoleLogger.logException("Failed to create email with the given settings:", e);
                    return;
                }
                String content = mailText;
                File file = null;
                if (SendMailSSL.this.settings.getProperty(EmailSettings.PASSWORD_AS_IMAGE).booleanValue()) {
                    try {
                        file = SendMailSSL.generateImage(name, SendMailSSL.this.plugin, newPass);
                        content = SendMailSSL.embedImageIntoEmailContent(file, email, content);
                    }
                    catch (IOException | EmailException e) {
                        ConsoleLogger.logException("Unable to send new password as image for email " + mailAddress + ":", e);
                    }
                }
                SendMailSSL.sendEmail(content, email);
                FileUtils.delete(file);
            }
        });
    }

    public void sendRecoveryCode(String name, String email, String code) {
        HtmlEmail htmlEmail;
        String message = this.replaceTagsForRecoveryCodeMail(this.settings.getRecoveryCodeEmailMessage(), name, code, this.settings.getProperty(SecuritySettings.RECOVERY_CODE_HOURS_VALID));
        try {
            htmlEmail = this.initializeMail(email);
        }
        catch (EmailException e) {
            ConsoleLogger.logException("Failed to create email for recovery code:", e);
            return;
        }
        SendMailSSL.sendEmail(message, htmlEmail);
    }

    private static File generateImage(String name, AuthMe plugin, String newPass) throws IOException {
        ImageGenerator gen = new ImageGenerator(newPass);
        File file = new File(plugin.getDataFolder(), name + "_new_pass.jpg");
        ImageIO.write((RenderedImage)gen.generateImage(), "jpg", file);
        return file;
    }

    private static String embedImageIntoEmailContent(File image, HtmlEmail email, String content) throws EmailException {
        FileDataSource source = new FileDataSource(image);
        String tag = email.embed(source, image.getName());
        return content.replace("<image />", "<img src=\"cid:" + tag + "\">");
    }

    private HtmlEmail initializeMail(String emailAddress) throws EmailException {
        String senderMail = this.settings.getProperty(EmailSettings.MAIL_ACCOUNT);
        String senderName = StringUtils.isEmpty(this.settings.getProperty(EmailSettings.MAIL_SENDER_NAME)) ? senderMail : this.settings.getProperty(EmailSettings.MAIL_SENDER_NAME);
        String mailPassword = this.settings.getProperty(EmailSettings.MAIL_PASSWORD);
        int port = this.settings.getProperty(EmailSettings.SMTP_PORT);
        HtmlEmail email = new HtmlEmail();
        email.setCharset("utf-8");
        email.setSmtpPort(port);
        email.setHostName(this.settings.getProperty(EmailSettings.SMTP_HOST));
        email.addTo(emailAddress);
        email.setFrom(senderMail, senderName);
        email.setSubject(this.settings.getProperty(EmailSettings.RECOVERY_MAIL_SUBJECT));
        email.setAuthentication(senderMail, mailPassword);
        this.setPropertiesForPort(email, port);
        return email;
    }

    private static boolean sendEmail(String content, HtmlEmail email) {
        try {
            email.setHtmlMsg(content);
            email.setTextMsg(content);
        }
        catch (EmailException e) {
            ConsoleLogger.logException("Your email.html config contains an error and cannot be sent:", e);
            return false;
        }
        try {
            email.send();
            return true;
        }
        catch (EmailException e) {
            ConsoleLogger.logException("Failed to send a mail to " + email.getToAddresses() + ":", e);
            return false;
        }
    }

    private String replaceTagsForPasswordMail(String mailText, String name, String newPass) {
        return mailText.replace("<playername />", name).replace("<servername />", this.plugin.getServer().getServerName()).replace("<generatedpass />", newPass);
    }

    private String replaceTagsForRecoveryCodeMail(String mailText, String name, String code, int hoursValid) {
        return mailText.replace("<playername />", name).replace("<servername />", this.plugin.getServer().getServerName()).replace("<recoverycode />", code).replace("<hoursvalid />", String.valueOf(hoursValid));
    }

    private void setPropertiesForPort(HtmlEmail email, int port) throws EmailException {
        switch (port) {
            case 587: {
                String oAuth2Token = this.settings.getProperty(EmailSettings.OAUTH2_TOKEN);
                if (!oAuth2Token.isEmpty()) {
                    if (Security.getProvider("Google OAuth2 Provider") == null) {
                        Security.addProvider(new OAuth2Provider());
                    }
                    Properties mailProperties = email.getMailSession().getProperties();
                    mailProperties.setProperty("mail.smtp.ssl.enable", "true");
                    mailProperties.setProperty("mail.smtp.auth.mechanisms", "XOAUTH2");
                    mailProperties.setProperty("mail.smtp.sasl.enable", "true");
                    mailProperties.setProperty("mail.smtp.sasl.mechanisms", "XOAUTH2");
                    mailProperties.setProperty("mail.smtp.auth.login.disable", "true");
                    mailProperties.setProperty("mail.smtp.auth.plain.disable", "true");
                    mailProperties.setProperty("mail.smpt.sasl.mechanisms.oauth2.oauthToken", oAuth2Token);
                    email.setMailSession(Session.getInstance(mailProperties));
                    break;
                }
                email.setStartTLSEnabled(true);
                email.setStartTLSRequired(true);
                break;
            }
            case 25: {
                email.setStartTLSEnabled(true);
                email.setSSLCheckServerIdentity(true);
                break;
            }
            case 465: {
                email.setSslSmtpPort(Integer.toString(port));
                email.setSSLOnConnect(true);
                break;
            }
            default: {
                email.setStartTLSEnabled(true);
                email.setSSLOnConnect(true);
                email.setSSLCheckServerIdentity(true);
            }
        }
    }
}

