/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.FieldAccessException;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerCache;
import org.bukkit.plugin.Plugin;

class TabCompletePacketAdapter
extends PacketAdapter {
    public TabCompletePacketAdapter(AuthMe plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.TAB_COMPLETE});
    }

    public void onPacketReceiving(PacketEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.TAB_COMPLETE) {
            try {
                if (!PlayerCache.getInstance().isAuthenticated(event.getPlayer().getName().toLowerCase())) {
                    event.setCancelled(true);
                }
            }
            catch (FieldAccessException e) {
                ConsoleLogger.warning("Couldn't access field.");
            }
        }
    }

    public void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this);
    }

    public void unregister() {
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this);
    }
}

