/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.cache.auth.PlayerCache;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class InventoryPacketAdapter
extends PacketAdapter {
    private static final int PLAYER_INVENTORY = 0;
    private static final int CRAFTING_SIZE = 5;
    private static final int ARMOR_SIZE = 4;
    private static final int MAIN_SIZE = 27;
    private static final int HOTBAR_SIZE = 9;

    public InventoryPacketAdapter(AuthMe plugin) {
        super((Plugin)plugin, new PacketType[]{PacketType.Play.Server.SET_SLOT, PacketType.Play.Server.WINDOW_ITEMS});
    }

    public void onPacketSending(PacketEvent packetEvent) {
        Player player = packetEvent.getPlayer();
        PacketContainer packet = packetEvent.getPacket();
        byte windowId = ((Integer)packet.getIntegers().read(0)).byteValue();
        if (windowId == 0 && !PlayerCache.getInstance().isAuthenticated(player.getName())) {
            packetEvent.setCancelled(true);
        }
    }

    public void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this);
    }

    public void unregister() {
        ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this);
    }

    public void sendBlankInventoryPacket(Player player) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer inventoryPacket = protocolManager.createPacket(PacketType.Play.Server.WINDOW_ITEMS);
        inventoryPacket.getIntegers().write(0, (Object)0);
        int inventorySize = 45;
        Object[] blankInventory = new ItemStack[inventorySize];
        Arrays.fill(blankInventory, new ItemStack(Material.AIR));
        inventoryPacket.getItemArrayModifier().write(0, (Object)blankInventory);
        try {
            protocolManager.sendServerPacket(player, inventoryPacket, false);
        }
        catch (InvocationTargetException invocationExc) {
            this.plugin.getLogger().log(Level.WARNING, "Error during sending blank inventory", invocationExc);
        }
    }
}

